/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDashboardsRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, ListDashboardsRequest> {
    private final String dashboardNamePrefix;
    private final String nextToken;

    private ListDashboardsRequest(BuilderImpl builder) {
        super(builder);
        this.dashboardNamePrefix = builder.dashboardNamePrefix;
        this.nextToken = builder.nextToken;
    }

    public String dashboardNamePrefix() {
        return this.dashboardNamePrefix;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsRequest)) {
            return false;
        }
        ListDashboardsRequest other = (ListDashboardsRequest)((Object)obj);
        return Objects.equals(this.dashboardNamePrefix(), other.dashboardNamePrefix()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dashboardNamePrefix() != null) {
            sb.append("DashboardNamePrefix: ").append(this.dashboardNamePrefix()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardNamePrefix": {
                return Optional.of(clazz.cast(this.dashboardNamePrefix()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String dashboardNamePrefix;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsRequest model) {
            this.dashboardNamePrefix(model.dashboardNamePrefix);
            this.nextToken(model.nextToken);
        }

        public final String getDashboardNamePrefix() {
            return this.dashboardNamePrefix;
        }

        @Override
        public final Builder dashboardNamePrefix(String dashboardNamePrefix) {
            this.dashboardNamePrefix = dashboardNamePrefix;
            return this;
        }

        public final void setDashboardNamePrefix(String dashboardNamePrefix) {
            this.dashboardNamePrefix = dashboardNamePrefix;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListDashboardsRequest build() {
            return new ListDashboardsRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    CopyableBuilder<Builder, ListDashboardsRequest> {
        public Builder dashboardNamePrefix(String var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

