/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItemsCopier;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmHistoryResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, DescribeAlarmHistoryResponse> {
    private final List<AlarmHistoryItem> alarmHistoryItems;
    private final String nextToken;

    private DescribeAlarmHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.alarmHistoryItems = builder.alarmHistoryItems;
        this.nextToken = builder.nextToken;
    }

    public List<AlarmHistoryItem> alarmHistoryItems() {
        return this.alarmHistoryItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmHistoryItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryResponse)) {
            return false;
        }
        DescribeAlarmHistoryResponse other = (DescribeAlarmHistoryResponse)((Object)obj);
        return Objects.equals(this.alarmHistoryItems(), other.alarmHistoryItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.alarmHistoryItems() != null) {
            sb.append("AlarmHistoryItems: ").append(this.alarmHistoryItems()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmHistoryItems": {
                return Optional.of(clazz.cast(this.alarmHistoryItems()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<AlarmHistoryItem> alarmHistoryItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryResponse model) {
            this.alarmHistoryItems(model.alarmHistoryItems);
            this.nextToken(model.nextToken);
        }

        public final Collection<AlarmHistoryItem.Builder> getAlarmHistoryItems() {
            return this.alarmHistoryItems != null ? (Collection)this.alarmHistoryItems.stream().map(AlarmHistoryItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder alarmHistoryItems(Collection<AlarmHistoryItem> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copy(alarmHistoryItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmHistoryItems(AlarmHistoryItem ... alarmHistoryItems) {
            this.alarmHistoryItems(Arrays.asList(alarmHistoryItems));
            return this;
        }

        public final void setAlarmHistoryItems(Collection<AlarmHistoryItem.BuilderImpl> alarmHistoryItems) {
            this.alarmHistoryItems = AlarmHistoryItemsCopier.copyFromBuilder(alarmHistoryItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAlarmHistoryResponse build() {
            return new DescribeAlarmHistoryResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    CopyableBuilder<Builder, DescribeAlarmHistoryResponse> {
        public Builder alarmHistoryItems(Collection<AlarmHistoryItem> var1);

        public Builder alarmHistoryItems(AlarmHistoryItem ... var1);

        public Builder nextToken(String var1);
    }
}

