/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessagesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DashboardInvalidInputErrorException
extends CloudWatchException
implements ToCopyableBuilder<Builder, DashboardInvalidInputErrorException> {
    private final List<DashboardValidationMessage> dashboardValidationMessages;

    private DashboardInvalidInputErrorException(BuilderImpl builder) {
        super(builder.message);
        this.dashboardValidationMessages = builder.dashboardValidationMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public List<DashboardValidationMessage> dashboardValidationMessages() {
        return this.dashboardValidationMessages;
    }

    static final class BuilderImpl
    implements Builder {
        private List<DashboardValidationMessage> dashboardValidationMessages;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardInvalidInputErrorException model) {
            this.dashboardValidationMessages(model.dashboardValidationMessages);
            this.message = model.getMessage();
        }

        public final Collection<DashboardValidationMessage.Builder> getDashboardValidationMessages() {
            return this.dashboardValidationMessages != null ? (Collection)this.dashboardValidationMessages.stream().map(DashboardValidationMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copy(dashboardValidationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(DashboardValidationMessage ... dashboardValidationMessages) {
            this.dashboardValidationMessages(Arrays.asList(dashboardValidationMessages));
            return this;
        }

        public final void setDashboardValidationMessages(Collection<DashboardValidationMessage.BuilderImpl> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copyFromBuilder(dashboardValidationMessages);
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public DashboardInvalidInputErrorException build() {
            return new DashboardInvalidInputErrorException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DashboardInvalidInputErrorException> {
        public Builder dashboardValidationMessages(Collection<DashboardValidationMessage> var1);

        public Builder dashboardValidationMessages(DashboardValidationMessage ... var1);

        public Builder message(String var1);
    }
}

