/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest;

public class PutDashboardRequestMarshaller
implements Marshaller<Request<PutDashboardRequest>, PutDashboardRequest> {
    public Request<PutDashboardRequest> marshall(PutDashboardRequest putDashboardRequest) {
        if (putDashboardRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putDashboardRequest, "CloudWatchClient");
        request.addParameter("Action", "PutDashboard");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putDashboardRequest.dashboardName() != null) {
            request.addParameter("DashboardName", StringUtils.fromString((String)putDashboardRequest.dashboardName()));
        }
        if (putDashboardRequest.dashboardBody() != null) {
            request.addParameter("DashboardBody", StringUtils.fromString((String)putDashboardRequest.dashboardBody()));
        }
        return request;
    }
}

