/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessage;
import software.amazon.awssdk.services.cloudwatch.model.DashboardValidationMessagesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutDashboardResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, PutDashboardResponse> {
    private final List<DashboardValidationMessage> dashboardValidationMessages;

    private PutDashboardResponse(BuilderImpl builder) {
        this.dashboardValidationMessages = builder.dashboardValidationMessages;
    }

    public List<DashboardValidationMessage> dashboardValidationMessages() {
        return this.dashboardValidationMessages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardValidationMessages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDashboardResponse)) {
            return false;
        }
        PutDashboardResponse other = (PutDashboardResponse)((Object)obj);
        return Objects.equals(this.dashboardValidationMessages(), other.dashboardValidationMessages());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dashboardValidationMessages() != null) {
            sb.append("DashboardValidationMessages: ").append(this.dashboardValidationMessages()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardValidationMessages": {
                return Optional.of(clazz.cast(this.dashboardValidationMessages()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DashboardValidationMessage> dashboardValidationMessages;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDashboardResponse model) {
            this.dashboardValidationMessages(model.dashboardValidationMessages);
        }

        public final Collection<DashboardValidationMessage.Builder> getDashboardValidationMessages() {
            return this.dashboardValidationMessages != null ? (Collection)this.dashboardValidationMessages.stream().map(DashboardValidationMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardValidationMessages(Collection<DashboardValidationMessage> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copy(dashboardValidationMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardValidationMessages(DashboardValidationMessage ... dashboardValidationMessages) {
            this.dashboardValidationMessages(Arrays.asList(dashboardValidationMessages));
            return this;
        }

        public final void setDashboardValidationMessages(Collection<DashboardValidationMessage.BuilderImpl> dashboardValidationMessages) {
            this.dashboardValidationMessages = DashboardValidationMessagesCopier.copyFromBuilder(dashboardValidationMessages);
        }

        public PutDashboardResponse build() {
            return new PutDashboardResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutDashboardResponse> {
        public Builder dashboardValidationMessages(Collection<DashboardValidationMessage> var1);

        public Builder dashboardValidationMessages(DashboardValidationMessage ... var1);
    }
}

