/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudwatch.model.DashboardEntriesCopier;
import software.amazon.awssdk.services.cloudwatch.model.DashboardEntry;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDashboardsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListDashboardsResponse> {
    private final List<DashboardEntry> dashboardEntries;
    private final String nextToken;

    private ListDashboardsResponse(BuilderImpl builder) {
        this.dashboardEntries = builder.dashboardEntries;
        this.nextToken = builder.nextToken;
    }

    public List<DashboardEntry> dashboardEntries() {
        return this.dashboardEntries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardEntries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDashboardsResponse)) {
            return false;
        }
        ListDashboardsResponse other = (ListDashboardsResponse)((Object)obj);
        return Objects.equals(this.dashboardEntries(), other.dashboardEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dashboardEntries() != null) {
            sb.append("DashboardEntries: ").append(this.dashboardEntries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardEntries": {
                return Optional.of(clazz.cast(this.dashboardEntries()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<DashboardEntry> dashboardEntries;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDashboardsResponse model) {
            this.dashboardEntries(model.dashboardEntries);
            this.nextToken(model.nextToken);
        }

        public final Collection<DashboardEntry.Builder> getDashboardEntries() {
            return this.dashboardEntries != null ? (Collection)this.dashboardEntries.stream().map(DashboardEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dashboardEntries(Collection<DashboardEntry> dashboardEntries) {
            this.dashboardEntries = DashboardEntriesCopier.copy(dashboardEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dashboardEntries(DashboardEntry ... dashboardEntries) {
            this.dashboardEntries(Arrays.asList(dashboardEntries));
            return this;
        }

        public final void setDashboardEntries(Collection<DashboardEntry.BuilderImpl> dashboardEntries) {
            this.dashboardEntries = DashboardEntriesCopier.copyFromBuilder(dashboardEntries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListDashboardsResponse build() {
            return new ListDashboardsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListDashboardsResponse> {
        public Builder dashboardEntries(Collection<DashboardEntry> var1);

        public Builder dashboardEntries(DashboardEntry ... var1);

        public Builder nextToken(String var1);
    }
}

