/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.ExtendedStatisticsCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.services.cloudwatch.model.StatisticsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMetricStatisticsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetMetricStatisticsRequest> {
    private final String namespace;
    private final String metricName;
    private final List<Dimension> dimensions;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer period;
    private final List<String> statistics;
    private final List<String> extendedStatistics;
    private final String unit;

    private GetMetricStatisticsRequest(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.statistics = builder.statistics;
        this.extendedStatistics = builder.extendedStatistics;
        this.unit = builder.unit;
    }

    public String namespace() {
        return this.namespace;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Integer period() {
        return this.period;
    }

    public List<Statistic> statistics() {
        return TypeConverter.convert(this.statistics, Statistic::fromValue);
    }

    public List<String> statisticsStrings() {
        return this.statistics;
    }

    public List<String> extendedStatistics() {
        return this.extendedStatistics;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsRequest)) {
            return false;
        }
        GetMetricStatisticsRequest other = (GetMetricStatisticsRequest)((Object)obj);
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.statisticsStrings(), other.statisticsStrings()) && Objects.equals(this.extendedStatistics(), other.extendedStatistics()) && Objects.equals(this.unitString(), other.unitString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.period() != null) {
            sb.append("Period: ").append(this.period()).append(",");
        }
        if (this.statisticsStrings() != null) {
            sb.append("Statistics: ").append(this.statisticsStrings()).append(",");
        }
        if (this.extendedStatistics() != null) {
            sb.append("ExtendedStatistics: ").append(this.extendedStatistics()).append(",");
        }
        if (this.unitString() != null) {
            sb.append("Unit: ").append(this.unitString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "Dimensions": {
                return Optional.of(clazz.cast(this.dimensions()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "Period": {
                return Optional.of(clazz.cast(this.period()));
            }
            case "Statistics": {
                return Optional.of(clazz.cast(this.statisticsStrings()));
            }
            case "ExtendedStatistics": {
                return Optional.of(clazz.cast(this.extendedStatistics()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unitString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String metricName;
        private List<Dimension> dimensions;
        private Instant startTime;
        private Instant endTime;
        private Integer period;
        private List<String> statistics;
        private List<String> extendedStatistics;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsRequest model) {
            this.namespace(model.namespace);
            this.metricName(model.metricName);
            this.dimensions(model.dimensions);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.period(model.period);
            this.statistics(model.statistics);
            this.extendedStatistics(model.extendedStatistics);
            this.unit(model.unit);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Collection<String> getStatistics() {
            return this.statistics;
        }

        @Override
        public final Builder statistics(Collection<String> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(String ... statistics) {
            this.statistics(Arrays.asList(statistics));
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
        }

        public final Collection<String> getExtendedStatistics() {
            return this.extendedStatistics;
        }

        @Override
        public final Builder extendedStatistics(Collection<String> extendedStatistics) {
            this.extendedStatistics = ExtendedStatisticsCopier.copy(extendedStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedStatistics(String ... extendedStatistics) {
            this.extendedStatistics(Arrays.asList(extendedStatistics));
            return this;
        }

        public final void setExtendedStatistics(Collection<String> extendedStatistics) {
            this.extendedStatistics = ExtendedStatisticsCopier.copy(extendedStatistics);
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public GetMetricStatisticsRequest build() {
            return new GetMetricStatisticsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetMetricStatisticsRequest> {
        public Builder namespace(String var1);

        public Builder metricName(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder period(Integer var1);

        public Builder statistics(Collection<String> var1);

        public Builder statistics(String ... var1);

        public Builder extendedStatistics(Collection<String> var1);

        public Builder extendedStatistics(String ... var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);
    }
}

