/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClientBuilder;
import software.amazon.awssdk.services.cloudwatch.DefaultCloudWatchClientBuilder;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardInvalidInputErrorException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardNotFoundErrorException;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.InternalServiceException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidFormatException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidParameterValueException;
import software.amazon.awssdk.services.cloudwatch.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface CloudWatchClient
extends SdkAutoCloseable {
    public static final String SERVICE_NAME = "monitoring";

    public static CloudWatchClient create() {
        return (CloudWatchClient)CloudWatchClient.builder().build();
    }

    public static CloudWatchClientBuilder builder() {
        return new DefaultCloudWatchClientBuilder();
    }

    default public DeleteAlarmsResponse deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public DeleteAlarmsResponse deleteAlarms(Consumer<DeleteAlarmsRequest.Builder> deleteAlarmsRequest) throws ResourceNotFoundException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.deleteAlarms((DeleteAlarmsRequest)((Object)((DeleteAlarmsRequest.Builder)DeleteAlarmsRequest.builder().apply(deleteAlarmsRequest)).build()));
    }

    default public DeleteDashboardsResponse deleteDashboards(DeleteDashboardsRequest deleteDashboardsRequest) throws InvalidParameterValueException, DashboardNotFoundErrorException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public DeleteDashboardsResponse deleteDashboards(Consumer<DeleteDashboardsRequest.Builder> deleteDashboardsRequest) throws InvalidParameterValueException, DashboardNotFoundErrorException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.deleteDashboards((DeleteDashboardsRequest)((Object)((DeleteDashboardsRequest.Builder)DeleteDashboardsRequest.builder().apply(deleteDashboardsRequest)).build()));
    }

    default public DescribeAlarmHistoryResponse describeAlarmHistory() throws InvalidNextTokenException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.describeAlarmHistory((DescribeAlarmHistoryRequest)((Object)DescribeAlarmHistoryRequest.builder().build()));
    }

    default public DescribeAlarmHistoryResponse describeAlarmHistory(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAlarmHistoryResponse describeAlarmHistory(Consumer<DescribeAlarmHistoryRequest.Builder> describeAlarmHistoryRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.describeAlarmHistory((DescribeAlarmHistoryRequest)((Object)((DescribeAlarmHistoryRequest.Builder)DescribeAlarmHistoryRequest.builder().apply(describeAlarmHistoryRequest)).build()));
    }

    default public DescribeAlarmsResponse describeAlarms() throws InvalidNextTokenException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.describeAlarms((DescribeAlarmsRequest)((Object)DescribeAlarmsRequest.builder().build()));
    }

    default public DescribeAlarmsResponse describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAlarmsResponse describeAlarms(Consumer<DescribeAlarmsRequest.Builder> describeAlarmsRequest) throws InvalidNextTokenException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.describeAlarms((DescribeAlarmsRequest)((Object)((DescribeAlarmsRequest.Builder)DescribeAlarmsRequest.builder().apply(describeAlarmsRequest)).build()));
    }

    default public DescribeAlarmsForMetricResponse describeAlarmsForMetric(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) throws SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAlarmsForMetricResponse describeAlarmsForMetric(Consumer<DescribeAlarmsForMetricRequest.Builder> describeAlarmsForMetricRequest) throws SdkBaseException, SdkClientException, CloudWatchException {
        return this.describeAlarmsForMetric((DescribeAlarmsForMetricRequest)((Object)((DescribeAlarmsForMetricRequest.Builder)DescribeAlarmsForMetricRequest.builder().apply(describeAlarmsForMetricRequest)).build()));
    }

    default public DisableAlarmActionsResponse disableAlarmActions(DisableAlarmActionsRequest disableAlarmActionsRequest) throws SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public DisableAlarmActionsResponse disableAlarmActions(Consumer<DisableAlarmActionsRequest.Builder> disableAlarmActionsRequest) throws SdkBaseException, SdkClientException, CloudWatchException {
        return this.disableAlarmActions((DisableAlarmActionsRequest)((Object)((DisableAlarmActionsRequest.Builder)DisableAlarmActionsRequest.builder().apply(disableAlarmActionsRequest)).build()));
    }

    default public EnableAlarmActionsResponse enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) throws SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public EnableAlarmActionsResponse enableAlarmActions(Consumer<EnableAlarmActionsRequest.Builder> enableAlarmActionsRequest) throws SdkBaseException, SdkClientException, CloudWatchException {
        return this.enableAlarmActions((EnableAlarmActionsRequest)((Object)((EnableAlarmActionsRequest.Builder)EnableAlarmActionsRequest.builder().apply(enableAlarmActionsRequest)).build()));
    }

    default public GetDashboardResponse getDashboard(GetDashboardRequest getDashboardRequest) throws InvalidParameterValueException, DashboardNotFoundErrorException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public GetDashboardResponse getDashboard(Consumer<GetDashboardRequest.Builder> getDashboardRequest) throws InvalidParameterValueException, DashboardNotFoundErrorException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.getDashboard((GetDashboardRequest)((Object)((GetDashboardRequest.Builder)GetDashboardRequest.builder().apply(getDashboardRequest)).build()));
    }

    default public GetMetricStatisticsResponse getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public GetMetricStatisticsResponse getMetricStatistics(Consumer<GetMetricStatisticsRequest.Builder> getMetricStatisticsRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.getMetricStatistics((GetMetricStatisticsRequest)((Object)((GetMetricStatisticsRequest.Builder)GetMetricStatisticsRequest.builder().apply(getMetricStatisticsRequest)).build()));
    }

    default public ListDashboardsResponse listDashboards() throws InvalidParameterValueException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.listDashboards((ListDashboardsRequest)((Object)ListDashboardsRequest.builder().build()));
    }

    default public ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws InvalidParameterValueException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public ListDashboardsResponse listDashboards(Consumer<ListDashboardsRequest.Builder> listDashboardsRequest) throws InvalidParameterValueException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.listDashboards((ListDashboardsRequest)((Object)((ListDashboardsRequest.Builder)ListDashboardsRequest.builder().apply(listDashboardsRequest)).build()));
    }

    default public ListMetricsResponse listMetrics() throws InternalServiceException, InvalidParameterValueException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.listMetrics((ListMetricsRequest)((Object)ListMetricsRequest.builder().build()));
    }

    default public ListMetricsResponse listMetrics(ListMetricsRequest listMetricsRequest) throws InternalServiceException, InvalidParameterValueException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public ListMetricsResponse listMetrics(Consumer<ListMetricsRequest.Builder> listMetricsRequest) throws InternalServiceException, InvalidParameterValueException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.listMetrics((ListMetricsRequest)((Object)((ListMetricsRequest.Builder)ListMetricsRequest.builder().apply(listMetricsRequest)).build()));
    }

    default public PutDashboardResponse putDashboard(PutDashboardRequest putDashboardRequest) throws DashboardInvalidInputErrorException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public PutDashboardResponse putDashboard(Consumer<PutDashboardRequest.Builder> putDashboardRequest) throws DashboardInvalidInputErrorException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.putDashboard((PutDashboardRequest)((Object)((PutDashboardRequest.Builder)PutDashboardRequest.builder().apply(putDashboardRequest)).build()));
    }

    default public PutMetricAlarmResponse putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) throws LimitExceededException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public PutMetricAlarmResponse putMetricAlarm(Consumer<PutMetricAlarmRequest.Builder> putMetricAlarmRequest) throws LimitExceededException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.putMetricAlarm((PutMetricAlarmRequest)((Object)((PutMetricAlarmRequest.Builder)PutMetricAlarmRequest.builder().apply(putMetricAlarmRequest)).build()));
    }

    default public PutMetricDataResponse putMetricData(PutMetricDataRequest putMetricDataRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public PutMetricDataResponse putMetricData(Consumer<PutMetricDataRequest.Builder> putMetricDataRequest) throws InvalidParameterValueException, MissingRequiredParameterException, InvalidParameterCombinationException, InternalServiceException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.putMetricData((PutMetricDataRequest)((Object)((PutMetricDataRequest.Builder)PutMetricDataRequest.builder().apply(putMetricDataRequest)).build()));
    }

    default public SetAlarmStateResponse setAlarmState(SetAlarmStateRequest setAlarmStateRequest) throws ResourceNotFoundException, InvalidFormatException, SdkBaseException, SdkClientException, CloudWatchException {
        throw new UnsupportedOperationException();
    }

    default public SetAlarmStateResponse setAlarmState(Consumer<SetAlarmStateRequest.Builder> setAlarmStateRequest) throws ResourceNotFoundException, InvalidFormatException, SdkBaseException, SdkClientException, CloudWatchException {
        return this.setAlarmState((SetAlarmStateRequest)((Object)((SetAlarmStateRequest.Builder)SetAlarmStateRequest.builder().apply(setAlarmStateRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

