/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutMetricDataRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutMetricDataRequest> {
    private final String namespace;
    private final List<MetricDatum> metricData;

    private PutMetricDataRequest(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricData = builder.metricData;
    }

    public String namespace() {
        return this.namespace;
    }

    public List<MetricDatum> metricData() {
        return this.metricData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.metricData() == null ? 0 : this.metricData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest)((Object)obj);
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.metricData() == null ^ this.metricData() == null) {
            return false;
        }
        return other.metricData() == null || other.metricData().equals(this.metricData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.metricData() != null) {
            sb.append("MetricData: ").append(this.metricData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Namespace": {
                return Optional.of(clazz.cast(this.namespace()));
            }
            case "MetricData": {
                return Optional.of(clazz.cast(this.metricData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String namespace;
        private List<MetricDatum> metricData;

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricDataRequest model) {
            this.namespace(model.namespace);
            this.metricData(model.metricData);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<MetricDatum.Builder> getMetricData() {
            return this.metricData != null ? (Collection)this.metricData.stream().map(MetricDatum::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum ... metricData) {
            this.metricData(Arrays.asList(metricData));
            return this;
        }

        public final void setMetricData(Collection<MetricDatum.BuilderImpl> metricData) {
            this.metricData = MetricDataCopier.copyFromBuilder(metricData);
        }

        public PutMetricDataRequest build() {
            return new PutMetricDataRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutMetricDataRequest> {
        public Builder namespace(String var1);

        public Builder metricData(Collection<MetricDatum> var1);

        public Builder metricData(MetricDatum ... var1);
    }
}

