/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetAlarmStateRequestMarshaller
implements Marshaller<Request<SetAlarmStateRequest>, SetAlarmStateRequest> {
    public Request<SetAlarmStateRequest> marshall(SetAlarmStateRequest setAlarmStateRequest) {
        if (setAlarmStateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setAlarmStateRequest, "CloudWatchClient");
        request.addParameter("Action", "SetAlarmState");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setAlarmStateRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)setAlarmStateRequest.alarmName()));
        }
        if (setAlarmStateRequest.stateValue() != null) {
            request.addParameter("StateValue", StringUtils.fromString((String)setAlarmStateRequest.stateValue()));
        }
        if (setAlarmStateRequest.stateReason() != null) {
            request.addParameter("StateReason", StringUtils.fromString((String)setAlarmStateRequest.stateReason()));
        }
        if (setAlarmStateRequest.stateReasonData() != null) {
            request.addParameter("StateReasonData", StringUtils.fromString((String)setAlarmStateRequest.stateReasonData()));
        }
        return request;
    }
}

