/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.util.StringUtils;

public class PutMetricAlarmRequestMarshaller
implements Marshaller<Request<PutMetricAlarmRequest>, PutMetricAlarmRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<PutMetricAlarmRequest> marshall(PutMetricAlarmRequest putMetricAlarmRequest) {
        List<Dimension> list;
        List<String> insufficientDataActionsList;
        List<String> alarmActionsList;
        List<String> oKActionsList;
        if (putMetricAlarmRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricAlarmRequest, "CloudWatchClient");
        request.addParameter("Action", "PutMetricAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricAlarmRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)putMetricAlarmRequest.alarmName()));
        }
        if (putMetricAlarmRequest.alarmDescription() != null) {
            request.addParameter("AlarmDescription", StringUtils.fromString((String)putMetricAlarmRequest.alarmDescription()));
        }
        if (putMetricAlarmRequest.actionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringUtils.fromBoolean((Boolean)putMetricAlarmRequest.actionsEnabled()));
        }
        if ((oKActionsList = putMetricAlarmRequest.okActions()) != null) {
            if (!oKActionsList.isEmpty()) {
                int oKActionsListIndex = 1;
                for (String string : oKActionsList) {
                    if (string != null) {
                        request.addParameter("OKActions.member." + oKActionsListIndex, StringUtils.fromString((String)string));
                    }
                    ++oKActionsListIndex;
                }
            } else {
                request.addParameter("OKActions", "");
            }
        }
        if ((alarmActionsList = putMetricAlarmRequest.alarmActions()) != null) {
            if (!alarmActionsList.isEmpty()) {
                int alarmActionsListIndex = 1;
                for (String string : alarmActionsList) {
                    if (string != null) {
                        request.addParameter("AlarmActions.member." + alarmActionsListIndex, StringUtils.fromString((String)string));
                    }
                    ++alarmActionsListIndex;
                }
            } else {
                request.addParameter("AlarmActions", "");
            }
        }
        if ((insufficientDataActionsList = putMetricAlarmRequest.insufficientDataActions()) != null) {
            if (!insufficientDataActionsList.isEmpty()) {
                boolean bl = true;
                for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                    void var6_12;
                    if (insufficientDataActionsListValue != null) {
                        request.addParameter("InsufficientDataActions.member." + (int)var6_12, StringUtils.fromString((String)insufficientDataActionsListValue));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("InsufficientDataActions", "");
            }
        }
        if (putMetricAlarmRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)putMetricAlarmRequest.metricName()));
        }
        if (putMetricAlarmRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)putMetricAlarmRequest.namespace()));
        }
        if (putMetricAlarmRequest.statistic() != null) {
            request.addParameter("Statistic", StringUtils.fromString((String)putMetricAlarmRequest.statistic()));
        }
        if (putMetricAlarmRequest.extendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringUtils.fromString((String)putMetricAlarmRequest.extendedStatistic()));
        }
        if ((list = putMetricAlarmRequest.dimensions()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (Dimension dimensionsListValue : list) {
                    void var7_18;
                    if (dimensionsListValue.name() != null) {
                        request.addParameter("Dimensions.member." + (int)var7_18 + ".Name", StringUtils.fromString((String)dimensionsListValue.name()));
                    }
                    if (dimensionsListValue.value() != null) {
                        request.addParameter("Dimensions.member." + (int)var7_18 + ".Value", StringUtils.fromString((String)dimensionsListValue.value()));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("Dimensions", "");
            }
        }
        if (putMetricAlarmRequest.period() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)putMetricAlarmRequest.period()));
        }
        if (putMetricAlarmRequest.unit() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)putMetricAlarmRequest.unit()));
        }
        if (putMetricAlarmRequest.evaluationPeriods() != null) {
            request.addParameter("EvaluationPeriods", StringUtils.fromInteger((Integer)putMetricAlarmRequest.evaluationPeriods()));
        }
        if (putMetricAlarmRequest.threshold() != null) {
            request.addParameter("Threshold", StringUtils.fromDouble((Double)putMetricAlarmRequest.threshold()));
        }
        if (putMetricAlarmRequest.comparisonOperator() != null) {
            request.addParameter("ComparisonOperator", StringUtils.fromString((String)putMetricAlarmRequest.comparisonOperator()));
        }
        if (putMetricAlarmRequest.treatMissingData() != null) {
            request.addParameter("TreatMissingData", StringUtils.fromString((String)putMetricAlarmRequest.treatMissingData()));
        }
        if (putMetricAlarmRequest.evaluateLowSampleCountPercentile() != null) {
            request.addParameter("EvaluateLowSampleCountPercentile", StringUtils.fromString((String)putMetricAlarmRequest.evaluateLowSampleCountPercentile()));
        }
        return request;
    }
}

