/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.model.MetricsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListMetricsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListMetricsResponse> {
    private final List<Metric> metrics;
    private final String nextToken;

    private ListMetricsResponse(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.nextToken = builder.nextToken;
    }

    public List<Metric> metrics() {
        return this.metrics;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metrics() == null ? 0 : this.metrics().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsResponse)) {
            return false;
        }
        ListMetricsResponse other = (ListMetricsResponse)((Object)obj);
        if (other.metrics() == null ^ this.metrics() == null) {
            return false;
        }
        if (other.metrics() != null && !other.metrics().equals(this.metrics())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metrics() != null) {
            sb.append("Metrics: ").append(this.metrics()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Metric> metrics;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricsResponse model) {
            this.setMetrics(model.metrics);
            this.setNextToken(model.nextToken);
        }

        public final Collection<Metric> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Collection<Metric> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Metric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        public final void setMetrics(Collection<Metric> metrics) {
            this.metrics = MetricsCopier.copy(metrics);
        }

        @SafeVarargs
        public final void setMetrics(Metric ... metrics) {
            this.metrics(Arrays.asList(metrics));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListMetricsResponse build() {
            return new ListMetricsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListMetricsResponse> {
        public Builder metrics(Collection<Metric> var1);

        public Builder metrics(Metric ... var1);

        public Builder nextToken(String var1);
    }
}

