/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery;
import software.amazon.awssdk.services.cloudwatch.model.MetricStat;

public class GetMetricDataRequestMarshaller
implements Marshaller<Request<GetMetricDataRequest>, GetMetricDataRequest> {
    public Request<GetMetricDataRequest> marshall(GetMetricDataRequest getMetricDataRequest) {
        if (getMetricDataRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getMetricDataRequest, "CloudWatchClient");
        request.addParameter("Action", "GetMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getMetricDataRequest.metricDataQueries().isEmpty() && !(getMetricDataRequest.metricDataQueries() instanceof SdkAutoConstructList)) {
            request.addParameter("MetricDataQueries", "");
        } else if (!getMetricDataRequest.metricDataQueries().isEmpty() && !(getMetricDataRequest.metricDataQueries() instanceof SdkAutoConstructList)) {
            List<MetricDataQuery> metricDataQueriesList = getMetricDataRequest.metricDataQueries();
            int metricDataQueriesListIndex = 1;
            for (MetricDataQuery metricDataQueriesListValue : metricDataQueriesList) {
                MetricStat metricStat;
                if (metricDataQueriesListValue.id() != null) {
                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Id", StringConversion.fromString((String)metricDataQueriesListValue.id()));
                }
                if ((metricStat = metricDataQueriesListValue.metricStat()) != null) {
                    Metric metric = metricStat.metric();
                    if (metric != null) {
                        if (metric.namespace() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Namespace", StringConversion.fromString((String)metric.namespace()));
                        }
                        if (metric.metricName() != null) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.MetricName", StringConversion.fromString((String)metric.metricName()));
                        }
                        if (metric.dimensions().isEmpty() && !(metric.dimensions() instanceof SdkAutoConstructList)) {
                            request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions", "");
                        } else if (!metric.dimensions().isEmpty() && !(metric.dimensions() instanceof SdkAutoConstructList)) {
                            List<Dimension> dimensionsList = metric.dimensions();
                            int dimensionsListIndex = 1;
                            for (Dimension dimensionsListValue : dimensionsList) {
                                if (dimensionsListValue.name() != null) {
                                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Name", StringConversion.fromString((String)dimensionsListValue.name()));
                                }
                                if (dimensionsListValue.value() != null) {
                                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Metric.Dimensions.member." + dimensionsListIndex + ".Value", StringConversion.fromString((String)dimensionsListValue.value()));
                                }
                                ++dimensionsListIndex;
                            }
                        }
                    }
                    if (metricStat.period() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Period", StringConversion.fromInteger((Integer)metricStat.period()));
                    }
                    if (metricStat.stat() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Stat", StringConversion.fromString((String)metricStat.stat()));
                    }
                    if (metricStat.unitAsString() != null) {
                        request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".MetricStat.Unit", StringConversion.fromString((String)metricStat.unitAsString()));
                    }
                }
                if (metricDataQueriesListValue.expression() != null) {
                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Expression", StringConversion.fromString((String)metricDataQueriesListValue.expression()));
                }
                if (metricDataQueriesListValue.label() != null) {
                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".Label", StringConversion.fromString((String)metricDataQueriesListValue.label()));
                }
                if (metricDataQueriesListValue.returnData() != null) {
                    request.addParameter("MetricDataQueries.member." + metricDataQueriesListIndex + ".ReturnData", StringConversion.fromBoolean((Boolean)metricDataQueriesListValue.returnData()));
                }
                ++metricDataQueriesListIndex;
            }
        }
        if (getMetricDataRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)getMetricDataRequest.startTime()));
        }
        if (getMetricDataRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)getMetricDataRequest.endTime()));
        }
        if (getMetricDataRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)getMetricDataRequest.nextToken()));
        }
        if (getMetricDataRequest.scanByAsString() != null) {
            request.addParameter("ScanBy", StringConversion.fromString((String)getMetricDataRequest.scanByAsString()));
        }
        if (getMetricDataRequest.maxDatapoints() != null) {
            request.addParameter("MaxDatapoints", StringConversion.fromInteger((Integer)getMetricDataRequest.maxDatapoints()));
        }
        return request;
    }
}

