/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest;

public class DeleteDashboardsRequestMarshaller
implements Marshaller<Request<DeleteDashboardsRequest>, DeleteDashboardsRequest> {
    public Request<DeleteDashboardsRequest> marshall(DeleteDashboardsRequest deleteDashboardsRequest) {
        if (deleteDashboardsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDashboardsRequest, "CloudWatchClient");
        request.addParameter("Action", "DeleteDashboards");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDashboardsRequest.dashboardNames().isEmpty() && !(deleteDashboardsRequest.dashboardNames() instanceof SdkAutoConstructList)) {
            request.addParameter("DashboardNames", "");
        } else if (!deleteDashboardsRequest.dashboardNames().isEmpty() && !(deleteDashboardsRequest.dashboardNames() instanceof SdkAutoConstructList)) {
            List<String> dashboardNamesList = deleteDashboardsRequest.dashboardNames();
            int dashboardNamesListIndex = 1;
            for (String dashboardNamesListValue : dashboardNamesList) {
                if (dashboardNamesListValue != null) {
                    request.addParameter("DashboardNames.member." + dashboardNamesListIndex, StringConversion.fromString((String)dashboardNamesListValue));
                }
                ++dashboardNamesListIndex;
            }
        }
        return request;
    }
}

