/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmsForMetricRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, DescribeAlarmsForMetricRequest> {
    private final String metricName;
    private final String namespace;
    private final String statistic;
    private final String extendedStatistic;
    private final List<Dimension> dimensions;
    private final Integer period;
    private final String unit;

    private DescribeAlarmsForMetricRequest(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.namespace = builder.namespace;
        this.statistic = builder.statistic;
        this.extendedStatistic = builder.extendedStatistic;
        this.dimensions = builder.dimensions;
        this.period = builder.period;
        this.unit = builder.unit;
    }

    public String metricName() {
        return this.metricName;
    }

    public String namespace() {
        return this.namespace;
    }

    public Statistic statistic() {
        return Statistic.fromValue(this.statistic);
    }

    public String statisticAsString() {
        return this.statistic;
    }

    public String extendedStatistic() {
        return this.extendedStatistic;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Integer period() {
        return this.period;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitAsString() {
        return this.unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedStatistic());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmsForMetricRequest)) {
            return false;
        }
        DescribeAlarmsForMetricRequest other = (DescribeAlarmsForMetricRequest)((Object)obj);
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.statisticAsString(), other.statisticAsString()) && Objects.equals(this.extendedStatistic(), other.extendedStatistic()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.unitAsString(), other.unitAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAlarmsForMetricRequest").add("MetricName", (Object)this.metricName()).add("Namespace", (Object)this.namespace()).add("Statistic", (Object)this.statisticAsString()).add("ExtendedStatistic", (Object)this.extendedStatistic()).add("Dimensions", this.dimensions()).add("Period", (Object)this.period()).add("Unit", (Object)this.unitAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "Namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "Statistic": {
                return Optional.ofNullable(clazz.cast(this.statisticAsString()));
            }
            case "ExtendedStatistic": {
                return Optional.ofNullable(clazz.cast(this.extendedStatistic()));
            }
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String metricName;
        private String namespace;
        private String statistic;
        private String extendedStatistic;
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();
        private Integer period;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmsForMetricRequest model) {
            super(model);
            this.metricName(model.metricName);
            this.namespace(model.namespace);
            this.statistic(model.statistic);
            this.extendedStatistic(model.extendedStatistic);
            this.dimensions(model.dimensions);
            this.period(model.period);
            this.unit(model.unit);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getStatistic() {
            return this.statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic.toString());
            return this;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        public final String getExtendedStatistic() {
            return this.extendedStatistic;
        }

        @Override
        public final Builder extendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
            return this;
        }

        public final void setExtendedStatistic(String extendedStatistic) {
            this.extendedStatistic = extendedStatistic;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder> ... dimensions) {
            this.dimensions(Stream.of(dimensions).map(c -> (Dimension)((Dimension.Builder)Dimension.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmsForMetricRequest build() {
            return new DescribeAlarmsForMetricRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    CopyableBuilder<Builder, DescribeAlarmsForMetricRequest> {
        public Builder metricName(String var1);

        public Builder namespace(String var1);

        public Builder statistic(String var1);

        public Builder statistic(Statistic var1);

        public Builder extendedStatistic(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder dimensions(Consumer<Dimension.Builder> ... var1);

        public Builder period(Integer var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

