/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;

public class PutMetricAlarmRequestMarshaller
implements Marshaller<Request<PutMetricAlarmRequest>, PutMetricAlarmRequest> {
    public Request<PutMetricAlarmRequest> marshall(PutMetricAlarmRequest putMetricAlarmRequest) {
        if (putMetricAlarmRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putMetricAlarmRequest, "CloudWatchClient");
        request.addParameter("Action", "PutMetricAlarm");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricAlarmRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringConversion.fromString((String)putMetricAlarmRequest.alarmName()));
        }
        if (putMetricAlarmRequest.alarmDescription() != null) {
            request.addParameter("AlarmDescription", StringConversion.fromString((String)putMetricAlarmRequest.alarmDescription()));
        }
        if (putMetricAlarmRequest.actionsEnabled() != null) {
            request.addParameter("ActionsEnabled", StringConversion.fromBoolean((Boolean)putMetricAlarmRequest.actionsEnabled()));
        }
        if (putMetricAlarmRequest.okActions().isEmpty() && !(putMetricAlarmRequest.okActions() instanceof SdkAutoConstructList)) {
            request.addParameter("OKActions", "");
        } else if (!putMetricAlarmRequest.okActions().isEmpty() && !(putMetricAlarmRequest.okActions() instanceof SdkAutoConstructList)) {
            List<String> oKActionsList = putMetricAlarmRequest.okActions();
            int oKActionsListIndex = 1;
            for (String oKActionsListValue : oKActionsList) {
                if (oKActionsListValue != null) {
                    request.addParameter("OKActions.member." + oKActionsListIndex, StringConversion.fromString((String)oKActionsListValue));
                }
                ++oKActionsListIndex;
            }
        }
        if (putMetricAlarmRequest.alarmActions().isEmpty() && !(putMetricAlarmRequest.alarmActions() instanceof SdkAutoConstructList)) {
            request.addParameter("AlarmActions", "");
        } else if (!putMetricAlarmRequest.alarmActions().isEmpty() && !(putMetricAlarmRequest.alarmActions() instanceof SdkAutoConstructList)) {
            List<String> alarmActionsList = putMetricAlarmRequest.alarmActions();
            int alarmActionsListIndex = 1;
            for (String alarmActionsListValue : alarmActionsList) {
                if (alarmActionsListValue != null) {
                    request.addParameter("AlarmActions.member." + alarmActionsListIndex, StringConversion.fromString((String)alarmActionsListValue));
                }
                ++alarmActionsListIndex;
            }
        }
        if (putMetricAlarmRequest.insufficientDataActions().isEmpty() && !(putMetricAlarmRequest.insufficientDataActions() instanceof SdkAutoConstructList)) {
            request.addParameter("InsufficientDataActions", "");
        } else if (!putMetricAlarmRequest.insufficientDataActions().isEmpty() && !(putMetricAlarmRequest.insufficientDataActions() instanceof SdkAutoConstructList)) {
            List<String> insufficientDataActionsList = putMetricAlarmRequest.insufficientDataActions();
            int insufficientDataActionsListIndex = 1;
            for (String insufficientDataActionsListValue : insufficientDataActionsList) {
                if (insufficientDataActionsListValue != null) {
                    request.addParameter("InsufficientDataActions.member." + insufficientDataActionsListIndex, StringConversion.fromString((String)insufficientDataActionsListValue));
                }
                ++insufficientDataActionsListIndex;
            }
        }
        if (putMetricAlarmRequest.metricName() != null) {
            request.addParameter("MetricName", StringConversion.fromString((String)putMetricAlarmRequest.metricName()));
        }
        if (putMetricAlarmRequest.namespace() != null) {
            request.addParameter("Namespace", StringConversion.fromString((String)putMetricAlarmRequest.namespace()));
        }
        if (putMetricAlarmRequest.statisticAsString() != null) {
            request.addParameter("Statistic", StringConversion.fromString((String)putMetricAlarmRequest.statisticAsString()));
        }
        if (putMetricAlarmRequest.extendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringConversion.fromString((String)putMetricAlarmRequest.extendedStatistic()));
        }
        if (putMetricAlarmRequest.dimensions().isEmpty() && !(putMetricAlarmRequest.dimensions() instanceof SdkAutoConstructList)) {
            request.addParameter("Dimensions", "");
        } else if (!putMetricAlarmRequest.dimensions().isEmpty() && !(putMetricAlarmRequest.dimensions() instanceof SdkAutoConstructList)) {
            List<Dimension> dimensionsList = putMetricAlarmRequest.dimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringConversion.fromString((String)dimensionsListValue.name()));
                }
                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringConversion.fromString((String)dimensionsListValue.value()));
                }
                ++dimensionsListIndex;
            }
        }
        if (putMetricAlarmRequest.period() != null) {
            request.addParameter("Period", StringConversion.fromInteger((Integer)putMetricAlarmRequest.period()));
        }
        if (putMetricAlarmRequest.unitAsString() != null) {
            request.addParameter("Unit", StringConversion.fromString((String)putMetricAlarmRequest.unitAsString()));
        }
        if (putMetricAlarmRequest.evaluationPeriods() != null) {
            request.addParameter("EvaluationPeriods", StringConversion.fromInteger((Integer)putMetricAlarmRequest.evaluationPeriods()));
        }
        if (putMetricAlarmRequest.datapointsToAlarm() != null) {
            request.addParameter("DatapointsToAlarm", StringConversion.fromInteger((Integer)putMetricAlarmRequest.datapointsToAlarm()));
        }
        if (putMetricAlarmRequest.threshold() != null) {
            request.addParameter("Threshold", StringConversion.fromDouble((Double)putMetricAlarmRequest.threshold()));
        }
        if (putMetricAlarmRequest.comparisonOperatorAsString() != null) {
            request.addParameter("ComparisonOperator", StringConversion.fromString((String)putMetricAlarmRequest.comparisonOperatorAsString()));
        }
        if (putMetricAlarmRequest.treatMissingData() != null) {
            request.addParameter("TreatMissingData", StringConversion.fromString((String)putMetricAlarmRequest.treatMissingData()));
        }
        if (putMetricAlarmRequest.evaluateLowSampleCountPercentile() != null) {
            request.addParameter("EvaluateLowSampleCountPercentile", StringConversion.fromString((String)putMetricAlarmRequest.evaluateLowSampleCountPercentile()));
        }
        return request;
    }
}

