/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.time.Instant;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.MessageData;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResult;
import software.amazon.awssdk.services.cloudwatch.transform.MessageDataUnmarshaller;

public class MetricDataResultUnmarshaller
implements Unmarshaller<MetricDataResult, StaxUnmarshallerContext> {
    private static final MetricDataResultUnmarshaller INSTANCE = new MetricDataResultUnmarshaller();

    public MetricDataResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricDataResult.Builder metricDataResult;
        block12: {
            metricDataResult = MetricDataResult.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Instant> timestamps = null;
            ArrayList<Double> values = null;
            ArrayList<MessageData> messages = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    metricDataResult.timestamps(timestamps);
                    metricDataResult.values(values);
                    metricDataResult.messages(messages);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Id", targetDepth)) {
                        metricDataResult.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Label", targetDepth)) {
                        metricDataResult.label(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Timestamps", targetDepth)) {
                        timestamps = new ArrayList<Instant>();
                        continue;
                    }
                    if (context.testExpression("Timestamps/member", targetDepth)) {
                        timestamps.add(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Values", targetDepth)) {
                        values = new ArrayList<Double>();
                        continue;
                    }
                    if (context.testExpression("Values/member", targetDepth)) {
                        values.add(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StatusCode", targetDepth)) {
                        metricDataResult.statusCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Messages", targetDepth)) {
                        messages = new ArrayList<MessageData>();
                        continue;
                    }
                    if (!context.testExpression("Messages/member", targetDepth)) continue;
                    messages.add(MessageDataUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            metricDataResult.timestamps(timestamps);
            metricDataResult.values(values);
            metricDataResult.messages(messages);
        }
        return (MetricDataResult)metricDataResult.build();
    }

    public static MetricDataResultUnmarshaller getInstance() {
        return INSTANCE;
    }
}

