/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataQuery;
import software.amazon.awssdk.services.cloudwatch.transform.MetricStatUnmarshaller;

public class MetricDataQueryUnmarshaller
implements Unmarshaller<MetricDataQuery, StaxUnmarshallerContext> {
    private static final MetricDataQueryUnmarshaller INSTANCE = new MetricDataQueryUnmarshaller();

    public MetricDataQuery unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MetricDataQuery.Builder metricDataQuery = MetricDataQuery.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    metricDataQuery.id(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricStat", targetDepth)) {
                    metricDataQuery.metricStat(MetricStatUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Expression", targetDepth)) {
                    metricDataQuery.expression(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Label", targetDepth)) {
                    metricDataQuery.label(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ReturnData", targetDepth)) continue;
                metricDataQuery.returnData(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MetricDataQuery)metricDataQuery.build();
    }

    public static MetricDataQueryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

