/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;
import software.amazon.awssdk.services.cloudwatch.transform.DimensionUnmarshaller;

public class MetricAlarmUnmarshaller
implements Unmarshaller<MetricAlarm, StaxUnmarshallerContext> {
    private static final MetricAlarmUnmarshaller INSTANCE = new MetricAlarmUnmarshaller();

    public MetricAlarm unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricAlarm.Builder metricAlarm;
        block32: {
            metricAlarm = MetricAlarm.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> okActions = null;
            ArrayList<String> alarmActions = null;
            ArrayList<String> insufficientDataActions = null;
            ArrayList<Dimension> dimensions = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    metricAlarm.okActions(okActions);
                    metricAlarm.alarmActions(alarmActions);
                    metricAlarm.insufficientDataActions(insufficientDataActions);
                    metricAlarm.dimensions(dimensions);
                    break block32;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("AlarmName", targetDepth)) {
                        metricAlarm.alarmName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AlarmArn", targetDepth)) {
                        metricAlarm.alarmArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AlarmDescription", targetDepth)) {
                        metricAlarm.alarmDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AlarmConfigurationUpdatedTimestamp", targetDepth)) {
                        metricAlarm.alarmConfigurationUpdatedTimestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ActionsEnabled", targetDepth)) {
                        metricAlarm.actionsEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OKActions", targetDepth)) {
                        okActions = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("OKActions/member", targetDepth)) {
                        okActions.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AlarmActions", targetDepth)) {
                        alarmActions = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("AlarmActions/member", targetDepth)) {
                        alarmActions.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InsufficientDataActions", targetDepth)) {
                        insufficientDataActions = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("InsufficientDataActions/member", targetDepth)) {
                        insufficientDataActions.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StateValue", targetDepth)) {
                        metricAlarm.stateValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StateReason", targetDepth)) {
                        metricAlarm.stateReason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StateReasonData", targetDepth)) {
                        metricAlarm.stateReasonData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StateUpdatedTimestamp", targetDepth)) {
                        metricAlarm.stateUpdatedTimestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MetricName", targetDepth)) {
                        metricAlarm.metricName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Namespace", targetDepth)) {
                        metricAlarm.namespace(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Statistic", targetDepth)) {
                        metricAlarm.statistic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ExtendedStatistic", targetDepth)) {
                        metricAlarm.extendedStatistic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Dimensions", targetDepth)) {
                        dimensions = new ArrayList<Dimension>();
                        continue;
                    }
                    if (context.testExpression("Dimensions/member", targetDepth)) {
                        dimensions.add(DimensionUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Period", targetDepth)) {
                        metricAlarm.period(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Unit", targetDepth)) {
                        metricAlarm.unit(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EvaluationPeriods", targetDepth)) {
                        metricAlarm.evaluationPeriods(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DatapointsToAlarm", targetDepth)) {
                        metricAlarm.datapointsToAlarm(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Threshold", targetDepth)) {
                        metricAlarm.threshold(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ComparisonOperator", targetDepth)) {
                        metricAlarm.comparisonOperator(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TreatMissingData", targetDepth)) {
                        metricAlarm.treatMissingData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("EvaluateLowSampleCountPercentile", targetDepth)) continue;
                    metricAlarm.evaluateLowSampleCountPercentile(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            metricAlarm.okActions(okActions);
            metricAlarm.alarmActions(alarmActions);
            metricAlarm.insufficientDataActions(insufficientDataActions);
            metricAlarm.dimensions(dimensions);
        }
        return (MetricAlarm)metricAlarm.build();
    }

    public static MetricAlarmUnmarshaller getInstance() {
        return INSTANCE;
    }
}

