/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;

public class GetMetricStatisticsRequestMarshaller
implements Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {
    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        if (getMetricStatisticsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getMetricStatisticsRequest, "CloudWatchClient");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getMetricStatisticsRequest.namespace() != null) {
            request.addParameter("Namespace", StringConversion.fromString((String)getMetricStatisticsRequest.namespace()));
        }
        if (getMetricStatisticsRequest.metricName() != null) {
            request.addParameter("MetricName", StringConversion.fromString((String)getMetricStatisticsRequest.metricName()));
        }
        if (getMetricStatisticsRequest.dimensions().isEmpty() && !(getMetricStatisticsRequest.dimensions() instanceof SdkAutoConstructList)) {
            request.addParameter("Dimensions", "");
        } else if (!getMetricStatisticsRequest.dimensions().isEmpty() && !(getMetricStatisticsRequest.dimensions() instanceof SdkAutoConstructList)) {
            List<Dimension> dimensionsList = getMetricStatisticsRequest.dimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringConversion.fromString((String)dimensionsListValue.name()));
                }
                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringConversion.fromString((String)dimensionsListValue.value()));
                }
                ++dimensionsListIndex;
            }
        }
        if (getMetricStatisticsRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)getMetricStatisticsRequest.startTime()));
        }
        if (getMetricStatisticsRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)getMetricStatisticsRequest.endTime()));
        }
        if (getMetricStatisticsRequest.period() != null) {
            request.addParameter("Period", StringConversion.fromInteger((Integer)getMetricStatisticsRequest.period()));
        }
        if (getMetricStatisticsRequest.statisticsAsStrings().isEmpty() && !(getMetricStatisticsRequest.statisticsAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("Statistics", "");
        } else if (!getMetricStatisticsRequest.statisticsAsStrings().isEmpty() && !(getMetricStatisticsRequest.statisticsAsStrings() instanceof SdkAutoConstructList)) {
            List<String> statisticsList = getMetricStatisticsRequest.statisticsAsStrings();
            int statisticsListIndex = 1;
            for (String statisticsListValue : statisticsList) {
                if (statisticsListValue != null) {
                    request.addParameter("Statistics.member." + statisticsListIndex, StringConversion.fromString((String)statisticsListValue));
                }
                ++statisticsListIndex;
            }
        }
        if (getMetricStatisticsRequest.extendedStatistics().isEmpty() && !(getMetricStatisticsRequest.extendedStatistics() instanceof SdkAutoConstructList)) {
            request.addParameter("ExtendedStatistics", "");
        } else if (!getMetricStatisticsRequest.extendedStatistics().isEmpty() && !(getMetricStatisticsRequest.extendedStatistics() instanceof SdkAutoConstructList)) {
            List<String> extendedStatisticsList = getMetricStatisticsRequest.extendedStatistics();
            int extendedStatisticsListIndex = 1;
            for (String extendedStatisticsListValue : extendedStatisticsList) {
                if (extendedStatisticsListValue != null) {
                    request.addParameter("ExtendedStatistics.member." + extendedStatisticsListIndex, StringConversion.fromString((String)extendedStatisticsListValue));
                }
                ++extendedStatisticsListIndex;
            }
        }
        if (getMetricStatisticsRequest.unitAsString() != null) {
            request.addParameter("Unit", StringConversion.fromString((String)getMetricStatisticsRequest.unitAsString()));
        }
        return request;
    }
}

