/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;

public class EnableAlarmActionsRequestMarshaller
implements Marshaller<Request<EnableAlarmActionsRequest>, EnableAlarmActionsRequest> {
    public Request<EnableAlarmActionsRequest> marshall(EnableAlarmActionsRequest enableAlarmActionsRequest) {
        if (enableAlarmActionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)enableAlarmActionsRequest, "CloudWatchClient");
        request.addParameter("Action", "EnableAlarmActions");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableAlarmActionsRequest.alarmNames().isEmpty() && !(enableAlarmActionsRequest.alarmNames() instanceof SdkAutoConstructList)) {
            request.addParameter("AlarmNames", "");
        } else if (!enableAlarmActionsRequest.alarmNames().isEmpty() && !(enableAlarmActionsRequest.alarmNames() instanceof SdkAutoConstructList)) {
            List<String> alarmNamesList = enableAlarmActionsRequest.alarmNames();
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringConversion.fromString((String)alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        return request;
    }
}

