/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageData
implements ToCopyableBuilder<Builder, MessageData> {
    private final String code;
    private final String value;

    private MessageData(BuilderImpl builder) {
        this.code = builder.code;
        this.value = builder.value;
    }

    public String code() {
        return this.code;
    }

    public String value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageData)) {
            return false;
        }
        MessageData other = (MessageData)obj;
        return Objects.equals(this.code(), other.code()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"MessageData").add("Code", (Object)this.code()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageData model) {
            this.code(model.code);
            this.value(model.value);
        }

        public final String getCode() {
            return this.code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public MessageData build() {
            return new MessageData(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageData> {
        public Builder code(String var1);

        public Builder value(String var1);
    }
}

