/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;

public class PutMetricDataRequestMarshaller
implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {
    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {
        if (putMetricDataRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putMetricDataRequest, "CloudWatchClient");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricDataRequest.namespace() != null) {
            request.addParameter("Namespace", StringConversion.fromString((String)putMetricDataRequest.namespace()));
        }
        if (putMetricDataRequest.metricData().isEmpty() && !(putMetricDataRequest.metricData() instanceof SdkAutoConstructList)) {
            request.addParameter("MetricData", "");
        } else if (!putMetricDataRequest.metricData().isEmpty() && !(putMetricDataRequest.metricData() instanceof SdkAutoConstructList)) {
            List<MetricDatum> metricDataList = putMetricDataRequest.metricData();
            int metricDataListIndex = 1;
            for (MetricDatum metricDataListValue : metricDataList) {
                StatisticSet statisticValues;
                if (metricDataListValue.metricName() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName", StringConversion.fromString((String)metricDataListValue.metricName()));
                }
                if (metricDataListValue.dimensions().isEmpty() && !(metricDataListValue.dimensions() instanceof SdkAutoConstructList)) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions", "");
                } else if (!metricDataListValue.dimensions().isEmpty() && !(metricDataListValue.dimensions() instanceof SdkAutoConstructList)) {
                    List<Dimension> dimensionsList = metricDataListValue.dimensions();
                    int dimensionsListIndex = 1;
                    for (Dimension dimensionsListValue : dimensionsList) {
                        if (dimensionsListValue.name() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Name", StringConversion.fromString((String)dimensionsListValue.name()));
                        }
                        if (dimensionsListValue.value() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Value", StringConversion.fromString((String)dimensionsListValue.value()));
                        }
                        ++dimensionsListIndex;
                    }
                }
                if (metricDataListValue.timestamp() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp", StringConversion.fromInstant((Instant)metricDataListValue.timestamp()));
                }
                if (metricDataListValue.value() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Value", StringConversion.fromDouble((Double)metricDataListValue.value()));
                }
                if ((statisticValues = metricDataListValue.statisticValues()) != null) {
                    if (statisticValues.sampleCount() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount", StringConversion.fromDouble((Double)statisticValues.sampleCount()));
                    }
                    if (statisticValues.sum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum", StringConversion.fromDouble((Double)statisticValues.sum()));
                    }
                    if (statisticValues.minimum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum", StringConversion.fromDouble((Double)statisticValues.minimum()));
                    }
                    if (statisticValues.maximum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum", StringConversion.fromDouble((Double)statisticValues.maximum()));
                    }
                }
                if (metricDataListValue.unitAsString() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Unit", StringConversion.fromString((String)metricDataListValue.unitAsString()));
                }
                if (metricDataListValue.storageResolution() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".StorageResolution", StringConversion.fromInteger((Integer)metricDataListValue.storageResolution()));
                }
                ++metricDataListIndex;
            }
        }
        return request;
    }
}

