/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;

public class DescribeAlarmsForMetricRequestMarshaller
implements Marshaller<Request<DescribeAlarmsForMetricRequest>, DescribeAlarmsForMetricRequest> {
    public Request<DescribeAlarmsForMetricRequest> marshall(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {
        if (describeAlarmsForMetricRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeAlarmsForMetricRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarmsForMetric");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmsForMetricRequest.metricName() != null) {
            request.addParameter("MetricName", StringConversion.fromString((String)describeAlarmsForMetricRequest.metricName()));
        }
        if (describeAlarmsForMetricRequest.namespace() != null) {
            request.addParameter("Namespace", StringConversion.fromString((String)describeAlarmsForMetricRequest.namespace()));
        }
        if (describeAlarmsForMetricRequest.statisticAsString() != null) {
            request.addParameter("Statistic", StringConversion.fromString((String)describeAlarmsForMetricRequest.statisticAsString()));
        }
        if (describeAlarmsForMetricRequest.extendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringConversion.fromString((String)describeAlarmsForMetricRequest.extendedStatistic()));
        }
        if (describeAlarmsForMetricRequest.dimensions().isEmpty() && !(describeAlarmsForMetricRequest.dimensions() instanceof SdkAutoConstructList)) {
            request.addParameter("Dimensions", "");
        } else if (!describeAlarmsForMetricRequest.dimensions().isEmpty() && !(describeAlarmsForMetricRequest.dimensions() instanceof SdkAutoConstructList)) {
            List<Dimension> dimensionsList = describeAlarmsForMetricRequest.dimensions();
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringConversion.fromString((String)dimensionsListValue.name()));
                }
                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringConversion.fromString((String)dimensionsListValue.value()));
                }
                ++dimensionsListIndex;
            }
        }
        if (describeAlarmsForMetricRequest.period() != null) {
            request.addParameter("Period", StringConversion.fromInteger((Integer)describeAlarmsForMetricRequest.period()));
        }
        if (describeAlarmsForMetricRequest.unitAsString() != null) {
            request.addParameter("Unit", StringConversion.fromString((String)describeAlarmsForMetricRequest.unitAsString()));
        }
        return request;
    }
}

