/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.DashboardEntry;

public class DashboardEntryUnmarshaller
implements Unmarshaller<DashboardEntry, StaxUnmarshallerContext> {
    private static final DashboardEntryUnmarshaller INSTANCE = new DashboardEntryUnmarshaller();

    public DashboardEntry unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DashboardEntry.Builder dashboardEntry = DashboardEntry.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DashboardName", targetDepth)) {
                    dashboardEntry.dashboardName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DashboardArn", targetDepth)) {
                    dashboardEntry.dashboardArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastModified", targetDepth)) {
                    dashboardEntry.lastModified(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Size", targetDepth)) continue;
                dashboardEntry.size(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DashboardEntry)dashboardEntry.build();
    }

    public static DashboardEntryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

