/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;

public class DescribeAlarmHistoryPublisher
implements SdkPublisher<DescribeAlarmHistoryResponse> {
    private final CloudWatchAsyncClient client;
    private final DescribeAlarmHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAlarmHistoryPublisher(CloudWatchAsyncClient client, DescribeAlarmHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAlarmHistoryPublisher(CloudWatchAsyncClient client, DescribeAlarmHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAlarmHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAlarmHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AlarmHistoryItem> alarmHistoryItems() {
        Function<DescribeAlarmHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.alarmHistoryItems() != null) {
                return response.alarmHistoryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAlarmHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeAlarmHistoryPublisher resume(DescribeAlarmHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAlarmHistoryPublisher(this.client, (DescribeAlarmHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAlarmHistoryPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeAlarmHistoryResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeAlarmHistoryResponseFetcher
    implements AsyncPageFetcher<DescribeAlarmHistoryResponse> {
        private DescribeAlarmHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAlarmHistoryResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeAlarmHistoryResponse> nextPage(DescribeAlarmHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeAlarmHistoryPublisher.this.client.describeAlarmHistory(DescribeAlarmHistoryPublisher.this.firstRequest);
            }
            return DescribeAlarmHistoryPublisher.this.client.describeAlarmHistory((DescribeAlarmHistoryRequest)((Object)DescribeAlarmHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

