/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;

public class DescribeAlarmHistoryIterable
implements SdkIterable<DescribeAlarmHistoryResponse> {
    private final CloudWatchClient client;
    private final DescribeAlarmHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAlarmHistoryIterable(CloudWatchClient client, DescribeAlarmHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAlarmHistoryResponseFetcher();
    }

    public Iterator<DescribeAlarmHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AlarmHistoryItem> alarmHistoryItems() {
        Function<DescribeAlarmHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.alarmHistoryItems() != null) {
                return response.alarmHistoryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeAlarmHistoryIterable resume(DescribeAlarmHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAlarmHistoryIterable(this.client, (DescribeAlarmHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAlarmHistoryIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeAlarmHistoryResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeAlarmHistoryResponseFetcher
    implements SyncPageFetcher<DescribeAlarmHistoryResponse> {
        private DescribeAlarmHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAlarmHistoryResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeAlarmHistoryResponse nextPage(DescribeAlarmHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeAlarmHistoryIterable.this.client.describeAlarmHistory(DescribeAlarmHistoryIterable.this.firstRequest);
            }
            return DescribeAlarmHistoryIterable.this.client.describeAlarmHistory((DescribeAlarmHistoryRequest)((Object)DescribeAlarmHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

