/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDashboardResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetDashboardResponse> {
    private final String dashboardArn;
    private final String dashboardBody;
    private final String dashboardName;

    private GetDashboardResponse(BuilderImpl builder) {
        super(builder);
        this.dashboardArn = builder.dashboardArn;
        this.dashboardBody = builder.dashboardBody;
        this.dashboardName = builder.dashboardName;
    }

    public String dashboardArn() {
        return this.dashboardArn;
    }

    public String dashboardBody() {
        return this.dashboardBody;
    }

    public String dashboardName() {
        return this.dashboardName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashboardResponse)) {
            return false;
        }
        GetDashboardResponse other = (GetDashboardResponse)((Object)obj);
        return Objects.equals(this.dashboardArn(), other.dashboardArn()) && Objects.equals(this.dashboardBody(), other.dashboardBody()) && Objects.equals(this.dashboardName(), other.dashboardName());
    }

    public String toString() {
        return ToString.builder((String)"GetDashboardResponse").add("DashboardArn", (Object)this.dashboardArn()).add("DashboardBody", (Object)this.dashboardBody()).add("DashboardName", (Object)this.dashboardName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardArn": {
                return Optional.of(clazz.cast(this.dashboardArn()));
            }
            case "DashboardBody": {
                return Optional.of(clazz.cast(this.dashboardBody()));
            }
            case "DashboardName": {
                return Optional.of(clazz.cast(this.dashboardName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private String dashboardArn;
        private String dashboardBody;
        private String dashboardName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashboardResponse model) {
            super(model);
            this.dashboardArn(model.dashboardArn);
            this.dashboardBody(model.dashboardBody);
            this.dashboardName(model.dashboardName);
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        public final String getDashboardBody() {
            return this.dashboardBody;
        }

        @Override
        public final Builder dashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
            return this;
        }

        public final void setDashboardBody(String dashboardBody) {
            this.dashboardBody = dashboardBody;
        }

        public final String getDashboardName() {
            return this.dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        @Override
        public GetDashboardResponse build() {
            return new GetDashboardResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    CopyableBuilder<Builder, GetDashboardResponse> {
        public Builder dashboardArn(String var1);

        public Builder dashboardBody(String var1);

        public Builder dashboardName(String var1);
    }
}

