/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.awssdk.util.StringUtils;

public class PutMetricDataRequestMarshaller
implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {
    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {
        SdkInternalList metricDataList;
        if (putMetricDataRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMetricDataRequest, "CloudWatchClient");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putMetricDataRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)putMetricDataRequest.namespace()));
        }
        if (!(metricDataList = (SdkInternalList)putMetricDataRequest.metricData()).isEmpty() || !metricDataList.isAutoConstruct()) {
            int metricDataListIndex = 1;
            for (MetricDatum metricDataListValue : metricDataList) {
                StatisticSet statisticValues;
                SdkInternalList dimensionsList;
                if (metricDataListValue.metricName() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName", StringUtils.fromString((String)metricDataListValue.metricName()));
                }
                if (!(dimensionsList = (SdkInternalList)metricDataListValue.dimensions()).isEmpty() || !dimensionsList.isAutoConstruct()) {
                    int dimensionsListIndex = 1;
                    for (Dimension dimensionsListValue : dimensionsList) {
                        if (dimensionsListValue.name() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.name()));
                        }
                        if (dimensionsListValue.value() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.value()));
                        }
                        ++dimensionsListIndex;
                    }
                }
                if (metricDataListValue.timestamp() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp", StringUtils.fromDate((Date)metricDataListValue.timestamp()));
                }
                if (metricDataListValue.value() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Value", StringUtils.fromDouble((Double)metricDataListValue.value()));
                }
                if ((statisticValues = metricDataListValue.statisticValues()) != null) {
                    if (statisticValues.sampleCount() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount", StringUtils.fromDouble((Double)statisticValues.sampleCount()));
                    }
                    if (statisticValues.sum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum", StringUtils.fromDouble((Double)statisticValues.sum()));
                    }
                    if (statisticValues.minimum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum", StringUtils.fromDouble((Double)statisticValues.minimum()));
                    }
                    if (statisticValues.maximum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum", StringUtils.fromDouble((Double)statisticValues.maximum()));
                    }
                }
                if (metricDataListValue.unit() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Unit", StringUtils.fromString((String)metricDataListValue.unit()));
                }
                ++metricDataListIndex;
            }
        }
        return request;
    }
}

