/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.transform.DimensionUnmarshaller;

public class MetricUnmarshaller
implements Unmarshaller<Metric, StaxUnmarshallerContext> {
    private static MetricUnmarshaller INSTANCE;

    public Metric unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Metric.Builder metric = Metric.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Namespace", targetDepth)) {
                    metric.namespace(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricName", targetDepth)) {
                    metric.metricName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    metric.dimensions(new ArrayList<Dimension>());
                    continue;
                }
                if (!context.testExpression("Dimensions/member", targetDepth)) continue;
                metric.dimensions(DimensionUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Metric)metric.build();
    }

    public static MetricUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetricUnmarshaller();
        }
        return INSTANCE;
    }
}

