/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;
import software.amazon.awssdk.services.cloudwatch.transform.DimensionUnmarshaller;

public class MetricAlarmUnmarshaller
implements Unmarshaller<MetricAlarm, StaxUnmarshallerContext> {
    private static MetricAlarmUnmarshaller INSTANCE;

    public MetricAlarm unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MetricAlarm.Builder metricAlarm = MetricAlarm.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AlarmName", targetDepth)) {
                    metricAlarm.alarmName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AlarmArn", targetDepth)) {
                    metricAlarm.alarmArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AlarmDescription", targetDepth)) {
                    metricAlarm.alarmDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AlarmConfigurationUpdatedTimestamp", targetDepth)) {
                    metricAlarm.alarmConfigurationUpdatedTimestamp(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ActionsEnabled", targetDepth)) {
                    metricAlarm.actionsEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OKActions", targetDepth)) {
                    metricAlarm.okActions(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("OKActions/member", targetDepth)) {
                    metricAlarm.okActions(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AlarmActions", targetDepth)) {
                    metricAlarm.alarmActions(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("AlarmActions/member", targetDepth)) {
                    metricAlarm.alarmActions(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InsufficientDataActions", targetDepth)) {
                    metricAlarm.insufficientDataActions(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("InsufficientDataActions/member", targetDepth)) {
                    metricAlarm.insufficientDataActions(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StateValue", targetDepth)) {
                    metricAlarm.stateValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StateReason", targetDepth)) {
                    metricAlarm.stateReason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StateReasonData", targetDepth)) {
                    metricAlarm.stateReasonData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StateUpdatedTimestamp", targetDepth)) {
                    metricAlarm.stateUpdatedTimestamp(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricName", targetDepth)) {
                    metricAlarm.metricName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Namespace", targetDepth)) {
                    metricAlarm.namespace(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Statistic", targetDepth)) {
                    metricAlarm.statistic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExtendedStatistic", targetDepth)) {
                    metricAlarm.extendedStatistic(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    metricAlarm.dimensions(new ArrayList<Dimension>());
                    continue;
                }
                if (context.testExpression("Dimensions/member", targetDepth)) {
                    metricAlarm.dimensions(DimensionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Period", targetDepth)) {
                    metricAlarm.period(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Unit", targetDepth)) {
                    metricAlarm.unit(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EvaluationPeriods", targetDepth)) {
                    metricAlarm.evaluationPeriods(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Threshold", targetDepth)) {
                    metricAlarm.threshold(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ComparisonOperator", targetDepth)) {
                    metricAlarm.comparisonOperator(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TreatMissingData", targetDepth)) {
                    metricAlarm.treatMissingData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EvaluateLowSampleCountPercentile", targetDepth)) continue;
                metricAlarm.evaluateLowSampleCountPercentile(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MetricAlarm)metricAlarm.build();
    }

    public static MetricAlarmUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetricAlarmUnmarshaller();
        }
        return INSTANCE;
    }
}

