/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetMetricStatisticsRequestMarshaller
implements Marshaller<Request<GetMetricStatisticsRequest>, GetMetricStatisticsRequest> {
    public Request<GetMetricStatisticsRequest> marshall(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        SdkInternalList extendedStatisticsList;
        SdkInternalList statisticsList;
        SdkInternalList dimensionsList;
        if (getMetricStatisticsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getMetricStatisticsRequest, "CloudWatchClient");
        request.addParameter("Action", "GetMetricStatistics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (getMetricStatisticsRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)getMetricStatisticsRequest.namespace()));
        }
        if (getMetricStatisticsRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)getMetricStatisticsRequest.metricName()));
        }
        if (!(dimensionsList = (SdkInternalList)getMetricStatisticsRequest.dimensions()).isEmpty() || !dimensionsList.isAutoConstruct()) {
            int dimensionsListIndex = 1;
            for (Object dimensionsListValue : dimensionsList) {
                if (((Dimension)dimensionsListValue).name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)((Dimension)dimensionsListValue).name()));
                }
                if (((Dimension)dimensionsListValue).value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)((Dimension)dimensionsListValue).value()));
                }
                ++dimensionsListIndex;
            }
        }
        if (getMetricStatisticsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)getMetricStatisticsRequest.startTime()));
        }
        if (getMetricStatisticsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)getMetricStatisticsRequest.endTime()));
        }
        if (getMetricStatisticsRequest.period() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)getMetricStatisticsRequest.period()));
        }
        if (!(statisticsList = (SdkInternalList)getMetricStatisticsRequest.statistics()).isEmpty() || !statisticsList.isAutoConstruct()) {
            int statisticsListIndex = 1;
            for (String statisticsListValue : statisticsList) {
                if (statisticsListValue != null) {
                    request.addParameter("Statistics.member." + statisticsListIndex, StringUtils.fromString((String)statisticsListValue));
                }
                ++statisticsListIndex;
            }
        }
        if (!(extendedStatisticsList = (SdkInternalList)getMetricStatisticsRequest.extendedStatistics()).isEmpty() || !extendedStatisticsList.isAutoConstruct()) {
            int extendedStatisticsListIndex = 1;
            for (String extendedStatisticsListValue : extendedStatisticsList) {
                if (extendedStatisticsListValue != null) {
                    request.addParameter("ExtendedStatistics.member." + extendedStatisticsListIndex, StringUtils.fromString((String)extendedStatisticsListValue));
                }
                ++extendedStatisticsListIndex;
            }
        }
        if (getMetricStatisticsRequest.unit() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)getMetricStatisticsRequest.unit()));
        }
        return request;
    }
}

