/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAlarmsRequestMarshaller
implements Marshaller<Request<DescribeAlarmsRequest>, DescribeAlarmsRequest> {
    public Request<DescribeAlarmsRequest> marshall(DescribeAlarmsRequest describeAlarmsRequest) {
        if (describeAlarmsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmsRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarms");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList alarmNamesList = (SdkInternalList)describeAlarmsRequest.alarmNames();
        if (!alarmNamesList.isEmpty() || !alarmNamesList.isAutoConstruct()) {
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString((String)alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        if (describeAlarmsRequest.alarmNamePrefix() != null) {
            request.addParameter("AlarmNamePrefix", StringUtils.fromString((String)describeAlarmsRequest.alarmNamePrefix()));
        }
        if (describeAlarmsRequest.stateValue() != null) {
            request.addParameter("StateValue", StringUtils.fromString((String)describeAlarmsRequest.stateValue()));
        }
        if (describeAlarmsRequest.actionPrefix() != null) {
            request.addParameter("ActionPrefix", StringUtils.fromString((String)describeAlarmsRequest.actionPrefix()));
        }
        if (describeAlarmsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAlarmsRequest.maxRecords()));
        }
        if (describeAlarmsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAlarmsRequest.nextToken()));
        }
        return request;
    }
}

