/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAlarmsForMetricRequestMarshaller
implements Marshaller<Request<DescribeAlarmsForMetricRequest>, DescribeAlarmsForMetricRequest> {
    public Request<DescribeAlarmsForMetricRequest> marshall(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {
        SdkInternalList dimensionsList;
        if (describeAlarmsForMetricRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmsForMetricRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarmsForMetric");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmsForMetricRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)describeAlarmsForMetricRequest.metricName()));
        }
        if (describeAlarmsForMetricRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)describeAlarmsForMetricRequest.namespace()));
        }
        if (describeAlarmsForMetricRequest.statistic() != null) {
            request.addParameter("Statistic", StringUtils.fromString((String)describeAlarmsForMetricRequest.statistic()));
        }
        if (describeAlarmsForMetricRequest.extendedStatistic() != null) {
            request.addParameter("ExtendedStatistic", StringUtils.fromString((String)describeAlarmsForMetricRequest.extendedStatistic()));
        }
        if (!(dimensionsList = (SdkInternalList)describeAlarmsForMetricRequest.dimensions()).isEmpty() || !dimensionsList.isAutoConstruct()) {
            int dimensionsListIndex = 1;
            for (Dimension dimensionsListValue : dimensionsList) {
                if (dimensionsListValue.name() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.name()));
                }
                if (dimensionsListValue.value() != null) {
                    request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.value()));
                }
                ++dimensionsListIndex;
            }
        }
        if (describeAlarmsForMetricRequest.period() != null) {
            request.addParameter("Period", StringUtils.fromInteger((Integer)describeAlarmsForMetricRequest.period()));
        }
        if (describeAlarmsForMetricRequest.unit() != null) {
            request.addParameter("Unit", StringUtils.fromString((String)describeAlarmsForMetricRequest.unit()));
        }
        return request;
    }
}

