/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAlarmHistoryRequestMarshaller
implements Marshaller<Request<DescribeAlarmHistoryRequest>, DescribeAlarmHistoryRequest> {
    public Request<DescribeAlarmHistoryRequest> marshall(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        if (describeAlarmHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmHistoryRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarmHistory");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmHistoryRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)describeAlarmHistoryRequest.alarmName()));
        }
        if (describeAlarmHistoryRequest.historyItemType() != null) {
            request.addParameter("HistoryItemType", StringUtils.fromString((String)describeAlarmHistoryRequest.historyItemType()));
        }
        if (describeAlarmHistoryRequest.startDate() != null) {
            request.addParameter("StartDate", StringUtils.fromDate((Date)describeAlarmHistoryRequest.startDate()));
        }
        if (describeAlarmHistoryRequest.endDate() != null) {
            request.addParameter("EndDate", StringUtils.fromDate((Date)describeAlarmHistoryRequest.endDate()));
        }
        if (describeAlarmHistoryRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAlarmHistoryRequest.maxRecords()));
        }
        if (describeAlarmHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAlarmHistoryRequest.nextToken()));
        }
        return request;
    }
}

