/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem;

public class AlarmHistoryItemUnmarshaller
implements Unmarshaller<AlarmHistoryItem, StaxUnmarshallerContext> {
    private static AlarmHistoryItemUnmarshaller INSTANCE;

    public AlarmHistoryItem unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AlarmHistoryItem.Builder alarmHistoryItem = AlarmHistoryItem.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AlarmName", targetDepth)) {
                    alarmHistoryItem.alarmName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timestamp", targetDepth)) {
                    alarmHistoryItem.timestamp(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HistoryItemType", targetDepth)) {
                    alarmHistoryItem.historyItemType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HistorySummary", targetDepth)) {
                    alarmHistoryItem.historySummary(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("HistoryData", targetDepth)) continue;
                alarmHistoryItem.historyData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AlarmHistoryItem)alarmHistoryItem.build();
    }

    public static AlarmHistoryItemUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AlarmHistoryItemUnmarshaller();
        }
        return INSTANCE;
    }
}

