/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutMetricDataRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PutMetricDataRequest> {
    private final String namespace;
    private final List<MetricDatum> metricData;

    private PutMetricDataRequest(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricData = builder.metricData;
    }

    public String namespace() {
        return this.namespace;
    }

    public List<MetricDatum> metricData() {
        return this.metricData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.metricData() == null ? 0 : this.metricData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMetricDataRequest)) {
            return false;
        }
        PutMetricDataRequest other = (PutMetricDataRequest)((Object)obj);
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.metricData() == null ^ this.metricData() == null) {
            return false;
        }
        return other.metricData() == null || other.metricData().equals(this.metricData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.metricData() != null) {
            sb.append("MetricData: ").append(this.metricData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String namespace;
        private List<MetricDatum> metricData = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMetricDataRequest model) {
            this.setNamespace(model.namespace);
            this.setMetricData(model.metricData);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Collection<MetricDatum> getMetricData() {
            return this.metricData;
        }

        @Override
        public final Builder metricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricData(MetricDatum ... metricData) {
            if (this.metricData == null) {
                this.metricData = new SdkInternalList(metricData.length);
            }
            for (MetricDatum e : metricData) {
                this.metricData.add(e);
            }
            return this;
        }

        public final void setMetricData(Collection<MetricDatum> metricData) {
            this.metricData = MetricDataCopier.copy(metricData);
        }

        @SafeVarargs
        public final void setMetricData(MetricDatum ... metricData) {
            if (this.metricData == null) {
                this.metricData = new SdkInternalList(metricData.length);
            }
            for (MetricDatum e : metricData) {
                this.metricData.add(e);
            }
        }

        public PutMetricDataRequest build() {
            return new PutMetricDataRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PutMetricDataRequest> {
        public Builder namespace(String var1);

        public Builder metricData(Collection<MetricDatum> var1);

        public Builder metricData(MetricDatum ... var1);
    }
}

