/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtraildata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelInsufficientPermissionException;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelNotFoundException;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelUnsupportedSchemaException;
import software.amazon.awssdk.services.cloudtraildata.model.CloudTrailDataException;
import software.amazon.awssdk.services.cloudtraildata.model.DuplicatedAuditEventIdException;
import software.amazon.awssdk.services.cloudtraildata.model.InvalidChannelArnException;
import software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsRequest;
import software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsResponse;
import software.amazon.awssdk.services.cloudtraildata.model.UnsupportedOperationException;

/**
 * Service client for accessing AWS CloudTrail Data Service. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The CloudTrail Data Service lets you ingest events into CloudTrail from any source in your hybrid environments, such
 * as in-house or SaaS applications hosted on-premises or in the cloud, virtual machines, or containers. You can store,
 * access, analyze, troubleshoot and take action on this data without maintaining multiple log aggregators and reporting
 * tools. After you run <code>PutAuditEvents</code> to ingest your application activity into CloudTrail, you can use
 * CloudTrail Lake to search, query, and analyze the data that is logged from your applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CloudTrailDataClient extends AwsClient {
    String SERVICE_NAME = "cloudtrail-data";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cloudtrail-data";

    /**
     * <p>
     * Ingests your application events into CloudTrail Lake. A required parameter, <code>auditEvents</code>, accepts the
     * JSON records (also called <i>payload</i>) of events that you want CloudTrail to ingest. You can add up to 100 of
     * these events (or up to 1 MB) per <code>PutAuditEvents</code> request.
     * </p>
     *
     * @param putAuditEventsRequest
     * @return Result of the PutAuditEvents operation returned by the service.
     * @throws ChannelInsufficientPermissionException
     *         The caller's account ID must be the same as the channel owner's account ID.
     * @throws ChannelNotFoundException
     *         The channel could not be found.
     * @throws InvalidChannelArnException
     *         The specified channel ARN is not a valid channel ARN.
     * @throws ChannelUnsupportedSchemaException
     *         The schema type of the event is not supported.
     * @throws DuplicatedAuditEventIdException
     *         Two or more entries in the request have the same event ID.
     * @throws UnsupportedOperationException
     *         The operation requested is not supported in this region or account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailDataClient.PutAuditEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-data-2021-08-11/PutAuditEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAuditEventsResponse putAuditEvents(PutAuditEventsRequest putAuditEventsRequest)
            throws ChannelInsufficientPermissionException, ChannelNotFoundException, InvalidChannelArnException,
            ChannelUnsupportedSchemaException, DuplicatedAuditEventIdException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudTrailDataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Ingests your application events into CloudTrail Lake. A required parameter, <code>auditEvents</code>, accepts the
     * JSON records (also called <i>payload</i>) of events that you want CloudTrail to ingest. You can add up to 100 of
     * these events (or up to 1 MB) per <code>PutAuditEvents</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutAuditEventsRequest.Builder} avoiding the need to
     * create one manually via {@link PutAuditEventsRequest#builder()}
     * </p>
     *
     * @param putAuditEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsRequest.Builder} to create a
     *        request.
     * @return Result of the PutAuditEvents operation returned by the service.
     * @throws ChannelInsufficientPermissionException
     *         The caller's account ID must be the same as the channel owner's account ID.
     * @throws ChannelNotFoundException
     *         The channel could not be found.
     * @throws InvalidChannelArnException
     *         The specified channel ARN is not a valid channel ARN.
     * @throws ChannelUnsupportedSchemaException
     *         The schema type of the event is not supported.
     * @throws DuplicatedAuditEventIdException
     *         Two or more entries in the request have the same event ID.
     * @throws UnsupportedOperationException
     *         The operation requested is not supported in this region or account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudTrailDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudTrailDataClient.PutAuditEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudtrail-data-2021-08-11/PutAuditEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default PutAuditEventsResponse putAuditEvents(Consumer<PutAuditEventsRequest.Builder> putAuditEventsRequest)
            throws ChannelInsufficientPermissionException, ChannelNotFoundException, InvalidChannelArnException,
            ChannelUnsupportedSchemaException, DuplicatedAuditEventIdException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudTrailDataException {
        return putAuditEvents(PutAuditEventsRequest.builder().applyMutation(putAuditEventsRequest).build());
    }

    /**
     * Create a {@link CloudTrailDataClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CloudTrailDataClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CloudTrailDataClient}.
     */
    static CloudTrailDataClientBuilder builder() {
        return new DefaultCloudTrailDataClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CloudTrailDataServiceClientConfiguration serviceClientConfiguration() {
        throw new java.lang.UnsupportedOperationException();
    }
}
