/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtraildata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtraildata.model.AuditEvent;
import software.amazon.awssdk.services.cloudtraildata.model.AuditEventsCopier;
import software.amazon.awssdk.services.cloudtraildata.model.CloudTrailDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAuditEventsRequest
extends CloudTrailDataRequest
implements ToCopyableBuilder<Builder, PutAuditEventsRequest> {
    private static final SdkField<List<AuditEvent>> AUDIT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("auditEvents").getter(PutAuditEventsRequest.getter(PutAuditEventsRequest::auditEvents)).setter(PutAuditEventsRequest.setter(Builder::auditEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelArn").getter(PutAuditEventsRequest.getter(PutAuditEventsRequest::channelArn)).setter(PutAuditEventsRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("channelArn").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(PutAuditEventsRequest.getter(PutAuditEventsRequest::externalId)).setter(PutAuditEventsRequest.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("externalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_EVENTS_FIELD, CHANNEL_ARN_FIELD, EXTERNAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAuditEventsRequest.memberNameToFieldInitializer();
    private final List<AuditEvent> auditEvents;
    private final String channelArn;
    private final String externalId;

    private PutAuditEventsRequest(BuilderImpl builder) {
        super(builder);
        this.auditEvents = builder.auditEvents;
        this.channelArn = builder.channelArn;
        this.externalId = builder.externalId;
    }

    public final boolean hasAuditEvents() {
        return this.auditEvents != null && !(this.auditEvents instanceof SdkAutoConstructList);
    }

    public final List<AuditEvent> auditEvents() {
        return this.auditEvents;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String externalId() {
        return this.externalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuditEvents() ? this.auditEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAuditEventsRequest)) {
            return false;
        }
        PutAuditEventsRequest other = (PutAuditEventsRequest)((Object)obj);
        return this.hasAuditEvents() == other.hasAuditEvents() && Objects.equals(this.auditEvents(), other.auditEvents()) && Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"PutAuditEventsRequest").add("AuditEvents", this.hasAuditEvents() ? this.auditEvents() : null).add("ChannelArn", (Object)this.channelArn()).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "auditEvents": {
                return Optional.ofNullable(clazz.cast(this.auditEvents()));
            }
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auditEvents", AUDIT_EVENTS_FIELD);
        map.put("channelArn", CHANNEL_ARN_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAuditEventsRequest, T> g) {
        return obj -> g.apply((PutAuditEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailDataRequest.BuilderImpl
    implements Builder {
        private List<AuditEvent> auditEvents = DefaultSdkAutoConstructList.getInstance();
        private String channelArn;
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAuditEventsRequest model) {
            super(model);
            this.auditEvents(model.auditEvents);
            this.channelArn(model.channelArn);
            this.externalId(model.externalId);
        }

        public final List<AuditEvent.Builder> getAuditEvents() {
            List<AuditEvent.Builder> result = AuditEventsCopier.copyToBuilder(this.auditEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditEvents(Collection<AuditEvent.BuilderImpl> auditEvents) {
            this.auditEvents = AuditEventsCopier.copyFromBuilder(auditEvents);
        }

        @Override
        public final Builder auditEvents(Collection<AuditEvent> auditEvents) {
            this.auditEvents = AuditEventsCopier.copy(auditEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditEvents(AuditEvent ... auditEvents) {
            this.auditEvents(Arrays.asList(auditEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditEvents(Consumer<AuditEvent.Builder> ... auditEvents) {
            this.auditEvents(Stream.of(auditEvents).map(c -> (AuditEvent)((AuditEvent.Builder)AuditEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAuditEventsRequest build() {
            return new PutAuditEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAuditEventsRequest> {
        public Builder auditEvents(Collection<AuditEvent> var1);

        public Builder auditEvents(AuditEvent ... var1);

        public Builder auditEvents(Consumer<AuditEvent.Builder> ... var1);

        public Builder channelArn(String var1);

        public Builder externalId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

