/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtraildata;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataAsyncClient;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelInsufficientPermissionException;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelNotFoundException;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelUnsupportedSchemaException;
import software.amazon.awssdk.services.cloudtraildata.model.CloudTrailDataException;
import software.amazon.awssdk.services.cloudtraildata.model.DuplicatedAuditEventIdException;
import software.amazon.awssdk.services.cloudtraildata.model.InvalidChannelArnException;
import software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsRequest;
import software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsResponse;
import software.amazon.awssdk.services.cloudtraildata.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudtraildata.transform.PutAuditEventsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudTrailDataAsyncClient
implements CloudTrailDataAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudTrailDataAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final CloudTrailDataServiceClientConfiguration serviceClientConfiguration;

    protected DefaultCloudTrailDataAsyncClient(CloudTrailDataServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<PutAuditEventsResponse> putAuditEvents(PutAuditEventsRequest putAuditEventsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudTrailDataAsyncClient.resolveMetricPublishers(this.clientConfiguration, putAuditEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAuditEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAuditEventsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAuditEvents").withMarshaller((Marshaller)new PutAuditEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAuditEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudTrailDataAsyncClient.lambda$putAuditEvents$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailDataAsyncClient.lambda$putAuditEvents$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CloudTrailDataServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public final String serviceName() {
        return "cloudtrail-data";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudTrailDataException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ChannelUnsupportedSchema").exceptionBuilderSupplier(ChannelUnsupportedSchemaException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelNotFound").exceptionBuilderSupplier(ChannelNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatedAuditEventId").exceptionBuilderSupplier(DuplicatedAuditEventIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelInsufficientPermission").exceptionBuilderSupplier(ChannelInsufficientPermissionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidChannelARN").exceptionBuilderSupplier(InvalidChannelArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$putAuditEvents$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAuditEvents$1(List metricPublishers, MetricCollector apiCallMetricCollector, PutAuditEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

