/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceEventCategory {
    MANAGEMENT("Management"),
    DATA("Data"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceEventCategory> VALUE_MAP;
    private final String value;

    private SourceEventCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceEventCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceEventCategory> knownValues() {
        EnumSet<SourceEventCategory> knownValues = EnumSet.allOf(SourceEventCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceEventCategory.class, SourceEventCategory::toString);
    }
}

