/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.EventCategoryAggregation;
import software.amazon.awssdk.services.cloudtrail.model.Template;
import software.amazon.awssdk.services.cloudtrail.model.TemplatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AggregationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AggregationConfiguration> {
    private static final SdkField<List<String>> TEMPLATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Templates").getter(AggregationConfiguration.getter(AggregationConfiguration::templatesAsStrings)).setter(AggregationConfiguration.setter(Builder::templatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Templates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventCategory").getter(AggregationConfiguration.getter(AggregationConfiguration::eventCategoryAsString)).setter(AggregationConfiguration.setter(Builder::eventCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategory").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATES_FIELD, EVENT_CATEGORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AggregationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> templates;
    private final String eventCategory;

    private AggregationConfiguration(BuilderImpl builder) {
        this.templates = builder.templates;
        this.eventCategory = builder.eventCategory;
    }

    public final List<Template> templates() {
        return TemplatesCopier.copyStringToEnum(this.templates);
    }

    public final boolean hasTemplates() {
        return this.templates != null && !(this.templates instanceof SdkAutoConstructList);
    }

    public final List<String> templatesAsStrings() {
        return this.templates;
    }

    public final EventCategoryAggregation eventCategory() {
        return EventCategoryAggregation.fromValue(this.eventCategory);
    }

    public final String eventCategoryAsString() {
        return this.eventCategory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplates() ? this.templatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventCategoryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregationConfiguration)) {
            return false;
        }
        AggregationConfiguration other = (AggregationConfiguration)obj;
        return this.hasTemplates() == other.hasTemplates() && Objects.equals(this.templatesAsStrings(), other.templatesAsStrings()) && Objects.equals(this.eventCategoryAsString(), other.eventCategoryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AggregationConfiguration").add("Templates", this.hasTemplates() ? this.templatesAsStrings() : null).add("EventCategory", (Object)this.eventCategoryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Templates": {
                return Optional.ofNullable(clazz.cast(this.templatesAsStrings()));
            }
            case "EventCategory": {
                return Optional.ofNullable(clazz.cast(this.eventCategoryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Templates", TEMPLATES_FIELD);
        map.put("EventCategory", EVENT_CATEGORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AggregationConfiguration, T> g) {
        return obj -> g.apply((AggregationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> templates = DefaultSdkAutoConstructList.getInstance();
        private String eventCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregationConfiguration model) {
            this.templatesWithStrings(model.templates);
            this.eventCategory(model.eventCategory);
        }

        public final Collection<String> getTemplates() {
            if (this.templates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.templates;
        }

        public final void setTemplates(Collection<String> templates) {
            this.templates = TemplatesCopier.copy(templates);
        }

        @Override
        public final Builder templatesWithStrings(Collection<String> templates) {
            this.templates = TemplatesCopier.copy(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templatesWithStrings(String ... templates) {
            this.templatesWithStrings(Arrays.asList(templates));
            return this;
        }

        @Override
        public final Builder templates(Collection<Template> templates) {
            this.templates = TemplatesCopier.copyEnumToString(templates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templates(Template ... templates) {
            this.templates(Arrays.asList(templates));
            return this;
        }

        public final String getEventCategory() {
            return this.eventCategory;
        }

        public final void setEventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
        }

        @Override
        public final Builder eventCategory(String eventCategory) {
            this.eventCategory = eventCategory;
            return this;
        }

        @Override
        public final Builder eventCategory(EventCategoryAggregation eventCategory) {
            this.eventCategory(eventCategory == null ? null : eventCategory.toString());
            return this;
        }

        public AggregationConfiguration build() {
            return new AggregationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AggregationConfiguration> {
        public Builder templatesWithStrings(Collection<String> var1);

        public Builder templatesWithStrings(String ... var1);

        public Builder templates(Collection<Template> var1);

        public Builder templates(Template ... var1);

        public Builder eventCategory(String var1);

        public Builder eventCategory(EventCategoryAggregation var1);
    }
}

