/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.ContextKeySelector;
import software.amazon.awssdk.services.cloudtrail.model.ContextKeySelectorsCopier;
import software.amazon.awssdk.services.cloudtrail.model.MaxEventSize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventConfigurationResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, GetEventConfigurationResponse> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreArn").getter(GetEventConfigurationResponse.getter(GetEventConfigurationResponse::eventDataStoreArn)).setter(GetEventConfigurationResponse.setter(Builder::eventDataStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()}).build();
    private static final SdkField<String> MAX_EVENT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxEventSize").getter(GetEventConfigurationResponse.getter(GetEventConfigurationResponse::maxEventSizeAsString)).setter(GetEventConfigurationResponse.setter(Builder::maxEventSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEventSize").build()}).build();
    private static final SdkField<List<ContextKeySelector>> CONTEXT_KEY_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextKeySelectors").getter(GetEventConfigurationResponse.getter(GetEventConfigurationResponse::contextKeySelectors)).setter(GetEventConfigurationResponse.setter(Builder::contextKeySelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeySelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContextKeySelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD, MAX_EVENT_SIZE_FIELD, CONTEXT_KEY_SELECTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEventConfigurationResponse.memberNameToFieldInitializer();
    private final String eventDataStoreArn;
    private final String maxEventSize;
    private final List<ContextKeySelector> contextKeySelectors;

    private GetEventConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.maxEventSize = builder.maxEventSize;
        this.contextKeySelectors = builder.contextKeySelectors;
    }

    public final String eventDataStoreArn() {
        return this.eventDataStoreArn;
    }

    public final MaxEventSize maxEventSize() {
        return MaxEventSize.fromValue(this.maxEventSize);
    }

    public final String maxEventSizeAsString() {
        return this.maxEventSize;
    }

    public final boolean hasContextKeySelectors() {
        return this.contextKeySelectors != null && !(this.contextKeySelectors instanceof SdkAutoConstructList);
    }

    public final List<ContextKeySelector> contextKeySelectors() {
        return this.contextKeySelectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEventSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextKeySelectors() ? this.contextKeySelectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventConfigurationResponse)) {
            return false;
        }
        GetEventConfigurationResponse other = (GetEventConfigurationResponse)((Object)obj);
        return Objects.equals(this.eventDataStoreArn(), other.eventDataStoreArn()) && Objects.equals(this.maxEventSizeAsString(), other.maxEventSizeAsString()) && this.hasContextKeySelectors() == other.hasContextKeySelectors() && Objects.equals(this.contextKeySelectors(), other.contextKeySelectors());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventConfigurationResponse").add("EventDataStoreArn", (Object)this.eventDataStoreArn()).add("MaxEventSize", (Object)this.maxEventSizeAsString()).add("ContextKeySelectors", this.hasContextKeySelectors() ? this.contextKeySelectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStoreArn": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreArn()));
            }
            case "MaxEventSize": {
                return Optional.ofNullable(clazz.cast(this.maxEventSizeAsString()));
            }
            case "ContextKeySelectors": {
                return Optional.ofNullable(clazz.cast(this.contextKeySelectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventDataStoreArn", EVENT_DATA_STORE_ARN_FIELD);
        map.put("MaxEventSize", MAX_EVENT_SIZE_FIELD);
        map.put("ContextKeySelectors", CONTEXT_KEY_SELECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEventConfigurationResponse, T> g) {
        return obj -> g.apply((GetEventConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String eventDataStoreArn;
        private String maxEventSize;
        private List<ContextKeySelector> contextKeySelectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventConfigurationResponse model) {
            super(model);
            this.eventDataStoreArn(model.eventDataStoreArn);
            this.maxEventSize(model.maxEventSize);
            this.contextKeySelectors(model.contextKeySelectors);
        }

        public final String getEventDataStoreArn() {
            return this.eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getMaxEventSize() {
            return this.maxEventSize;
        }

        public final void setMaxEventSize(String maxEventSize) {
            this.maxEventSize = maxEventSize;
        }

        @Override
        public final Builder maxEventSize(String maxEventSize) {
            this.maxEventSize = maxEventSize;
            return this;
        }

        @Override
        public final Builder maxEventSize(MaxEventSize maxEventSize) {
            this.maxEventSize(maxEventSize == null ? null : maxEventSize.toString());
            return this;
        }

        public final List<ContextKeySelector.Builder> getContextKeySelectors() {
            List<ContextKeySelector.Builder> result = ContextKeySelectorsCopier.copyToBuilder(this.contextKeySelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContextKeySelectors(Collection<ContextKeySelector.BuilderImpl> contextKeySelectors) {
            this.contextKeySelectors = ContextKeySelectorsCopier.copyFromBuilder(contextKeySelectors);
        }

        @Override
        public final Builder contextKeySelectors(Collection<ContextKeySelector> contextKeySelectors) {
            this.contextKeySelectors = ContextKeySelectorsCopier.copy(contextKeySelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeySelectors(ContextKeySelector ... contextKeySelectors) {
            this.contextKeySelectors(Arrays.asList(contextKeySelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeySelectors(Consumer<ContextKeySelector.Builder> ... contextKeySelectors) {
            this.contextKeySelectors(Stream.of(contextKeySelectors).map(c -> (ContextKeySelector)((ContextKeySelector.Builder)ContextKeySelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEventConfigurationResponse build() {
            return new GetEventConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventConfigurationResponse> {
        public Builder eventDataStoreArn(String var1);

        public Builder maxEventSize(String var1);

        public Builder maxEventSize(MaxEventSize var1);

        public Builder contextKeySelectors(Collection<ContextKeySelector> var1);

        public Builder contextKeySelectors(ContextKeySelector ... var1);

        public Builder contextKeySelectors(Consumer<ContextKeySelector.Builder> ... var1);
    }
}

