/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector;
import software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelectorsCopier;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventDataStore
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventDataStore> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreArn").getter(EventDataStore.getter(EventDataStore::eventDataStoreArn)).setter(EventDataStore.setter(Builder::eventDataStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(EventDataStore.getter(EventDataStore::name)).setter(EventDataStore.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TerminationProtectionEnabled").getter(EventDataStore.getter(EventDataStore::terminationProtectionEnabled)).setter(EventDataStore.setter(Builder::terminationProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EventDataStore.getter(EventDataStore::statusAsString)).setter(EventDataStore.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedEventSelectors").getter(EventDataStore.getter(EventDataStore::advancedEventSelectors)).setter(EventDataStore.setter(Builder::advancedEventSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdvancedEventSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_REGION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiRegionEnabled").getter(EventDataStore.getter(EventDataStore::multiRegionEnabled)).setter(EventDataStore.setter(Builder::multiRegionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionEnabled").build()}).build();
    private static final SdkField<Boolean> ORGANIZATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OrganizationEnabled").getter(EventDataStore.getter(EventDataStore::organizationEnabled)).setter(EventDataStore.setter(Builder::organizationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationEnabled").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriod").getter(EventDataStore.getter(EventDataStore::retentionPeriod)).setter(EventDataStore.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTimestamp").getter(EventDataStore.getter(EventDataStore::createdTimestamp)).setter(EventDataStore.setter(Builder::createdTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()}).build();
    private static final SdkField<Instant> UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTimestamp").getter(EventDataStore.getter(EventDataStore::updatedTimestamp)).setter(EventDataStore.setter(Builder::updatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD, NAME_FIELD, TERMINATION_PROTECTION_ENABLED_FIELD, STATUS_FIELD, ADVANCED_EVENT_SELECTORS_FIELD, MULTI_REGION_ENABLED_FIELD, ORGANIZATION_ENABLED_FIELD, RETENTION_PERIOD_FIELD, CREATED_TIMESTAMP_FIELD, UPDATED_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventDataStore.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String eventDataStoreArn;
    private final String name;
    private final Boolean terminationProtectionEnabled;
    private final String status;
    private final List<AdvancedEventSelector> advancedEventSelectors;
    private final Boolean multiRegionEnabled;
    private final Boolean organizationEnabled;
    private final Integer retentionPeriod;
    private final Instant createdTimestamp;
    private final Instant updatedTimestamp;

    private EventDataStore(BuilderImpl builder) {
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.name = builder.name;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.status = builder.status;
        this.advancedEventSelectors = builder.advancedEventSelectors;
        this.multiRegionEnabled = builder.multiRegionEnabled;
        this.organizationEnabled = builder.organizationEnabled;
        this.retentionPeriod = builder.retentionPeriod;
        this.createdTimestamp = builder.createdTimestamp;
        this.updatedTimestamp = builder.updatedTimestamp;
    }

    public final String eventDataStoreArn() {
        return this.eventDataStoreArn;
    }

    public final String name() {
        return this.name;
    }

    @Deprecated
    public final Boolean terminationProtectionEnabled() {
        return this.terminationProtectionEnabled;
    }

    @Deprecated
    public final EventDataStoreStatus status() {
        return EventDataStoreStatus.fromValue(this.status);
    }

    @Deprecated
    public final String statusAsString() {
        return this.status;
    }

    @Deprecated
    public final boolean hasAdvancedEventSelectors() {
        return this.advancedEventSelectors != null && !(this.advancedEventSelectors instanceof SdkAutoConstructList);
    }

    @Deprecated
    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return this.advancedEventSelectors;
    }

    @Deprecated
    public final Boolean multiRegionEnabled() {
        return this.multiRegionEnabled;
    }

    @Deprecated
    public final Boolean organizationEnabled() {
        return this.organizationEnabled;
    }

    @Deprecated
    public final Integer retentionPeriod() {
        return this.retentionPeriod;
    }

    @Deprecated
    public final Instant createdTimestamp() {
        return this.createdTimestamp;
    }

    @Deprecated
    public final Instant updatedTimestamp() {
        return this.updatedTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDataStore)) {
            return false;
        }
        EventDataStore other = (EventDataStore)obj;
        return Objects.equals(this.eventDataStoreArn(), other.eventDataStoreArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.terminationProtectionEnabled(), other.terminationProtectionEnabled()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors() && Objects.equals(this.advancedEventSelectors(), other.advancedEventSelectors()) && Objects.equals(this.multiRegionEnabled(), other.multiRegionEnabled()) && Objects.equals(this.organizationEnabled(), other.organizationEnabled()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.createdTimestamp(), other.createdTimestamp()) && Objects.equals(this.updatedTimestamp(), other.updatedTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"EventDataStore").add("EventDataStoreArn", (Object)this.eventDataStoreArn()).add("Name", (Object)this.name()).add("TerminationProtectionEnabled", (Object)this.terminationProtectionEnabled()).add("Status", (Object)this.statusAsString()).add("AdvancedEventSelectors", this.hasAdvancedEventSelectors() ? this.advancedEventSelectors() : null).add("MultiRegionEnabled", (Object)this.multiRegionEnabled()).add("OrganizationEnabled", (Object)this.organizationEnabled()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("CreatedTimestamp", (Object)this.createdTimestamp()).add("UpdatedTimestamp", (Object)this.updatedTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStoreArn": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "TerminationProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationProtectionEnabled()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "AdvancedEventSelectors": {
                return Optional.ofNullable(clazz.cast(this.advancedEventSelectors()));
            }
            case "MultiRegionEnabled": {
                return Optional.ofNullable(clazz.cast(this.multiRegionEnabled()));
            }
            case "OrganizationEnabled": {
                return Optional.ofNullable(clazz.cast(this.organizationEnabled()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "CreatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimestamp()));
            }
            case "UpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.updatedTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventDataStoreArn", EVENT_DATA_STORE_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("TerminationProtectionEnabled", TERMINATION_PROTECTION_ENABLED_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("AdvancedEventSelectors", ADVANCED_EVENT_SELECTORS_FIELD);
        map.put("MultiRegionEnabled", MULTI_REGION_ENABLED_FIELD);
        map.put("OrganizationEnabled", ORGANIZATION_ENABLED_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("UpdatedTimestamp", UPDATED_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventDataStore, T> g) {
        return obj -> g.apply((EventDataStore)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventDataStoreArn;
        private String name;
        private Boolean terminationProtectionEnabled;
        private String status;
        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiRegionEnabled;
        private Boolean organizationEnabled;
        private Integer retentionPeriod;
        private Instant createdTimestamp;
        private Instant updatedTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDataStore model) {
            this.eventDataStoreArn(model.eventDataStoreArn);
            this.name(model.name);
            this.terminationProtectionEnabled(model.terminationProtectionEnabled);
            this.status(model.status);
            this.advancedEventSelectors(model.advancedEventSelectors);
            this.multiRegionEnabled(model.multiRegionEnabled);
            this.organizationEnabled(model.organizationEnabled);
            this.retentionPeriod(model.retentionPeriod);
            this.createdTimestamp(model.createdTimestamp);
            this.updatedTimestamp(model.updatedTimestamp);
        }

        public final String getEventDataStoreArn() {
            return this.eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Deprecated
        public final Boolean getTerminationProtectionEnabled() {
            return this.terminationProtectionEnabled;
        }

        @Deprecated
        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        @Deprecated
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        @Deprecated
        public final String getStatus() {
            return this.status;
        }

        @Deprecated
        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Deprecated
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Deprecated
        public final Builder status(EventDataStoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Deprecated
        public final List<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            List<AdvancedEventSelector.Builder> result = AdvancedEventSelectorsCopier.copyToBuilder(this.advancedEventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Deprecated
        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        @Deprecated
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder advancedEventSelectors(AdvancedEventSelector ... advancedEventSelectors) {
            this.advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        @Deprecated
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... advancedEventSelectors) {
            this.advancedEventSelectors(Stream.of(advancedEventSelectors).map(c -> (AdvancedEventSelector)((AdvancedEventSelector.Builder)AdvancedEventSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Deprecated
        public final Boolean getMultiRegionEnabled() {
            return this.multiRegionEnabled;
        }

        @Deprecated
        public final void setMultiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
        }

        @Override
        @Deprecated
        public final Builder multiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        @Deprecated
        public final Boolean getOrganizationEnabled() {
            return this.organizationEnabled;
        }

        @Deprecated
        public final void setOrganizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
        }

        @Override
        @Deprecated
        public final Builder organizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        @Deprecated
        public final Integer getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Deprecated
        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        @Deprecated
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        @Deprecated
        public final Instant getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        @Deprecated
        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        @Deprecated
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        @Deprecated
        public final Instant getUpdatedTimestamp() {
            return this.updatedTimestamp;
        }

        @Deprecated
        public final void setUpdatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
        }

        @Override
        @Deprecated
        public final Builder updatedTimestamp(Instant updatedTimestamp) {
            this.updatedTimestamp = updatedTimestamp;
            return this;
        }

        public EventDataStore build() {
            return new EventDataStore(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventDataStore> {
        public Builder eventDataStoreArn(String var1);

        public Builder name(String var1);

        @Deprecated
        public Builder terminationProtectionEnabled(Boolean var1);

        @Deprecated
        public Builder status(String var1);

        @Deprecated
        public Builder status(EventDataStoreStatus var1);

        @Deprecated
        public Builder advancedEventSelectors(Collection<AdvancedEventSelector> var1);

        @Deprecated
        public Builder advancedEventSelectors(AdvancedEventSelector ... var1);

        @Deprecated
        public Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder> ... var1);

        @Deprecated
        public Builder multiRegionEnabled(Boolean var1);

        @Deprecated
        public Builder organizationEnabled(Boolean var1);

        @Deprecated
        public Builder retentionPeriod(Integer var1);

        @Deprecated
        public Builder createdTimestamp(Instant var1);

        @Deprecated
        public Builder updatedTimestamp(Instant var1);
    }
}

