/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.InsightSelector;
import software.amazon.awssdk.services.cloudtrail.model.InsightSelectorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutInsightSelectorsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, PutInsightSelectorsResponse> {
    private static final SdkField<String> TRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrailARN").getter(PutInsightSelectorsResponse.getter(PutInsightSelectorsResponse::trailARN)).setter(PutInsightSelectorsResponse.setter(Builder::trailARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailARN").build()}).build();
    private static final SdkField<List<InsightSelector>> INSIGHT_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InsightSelectors").getter(PutInsightSelectorsResponse.getter(PutInsightSelectorsResponse::insightSelectors)).setter(PutInsightSelectorsResponse.setter(Builder::insightSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightSelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreArn").getter(PutInsightSelectorsResponse.getter(PutInsightSelectorsResponse::eventDataStoreArn)).setter(PutInsightSelectorsResponse.setter(Builder::eventDataStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()}).build();
    private static final SdkField<String> INSIGHTS_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightsDestination").getter(PutInsightSelectorsResponse.getter(PutInsightSelectorsResponse::insightsDestination)).setter(PutInsightSelectorsResponse.setter(Builder::insightsDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightsDestination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_ARN_FIELD, INSIGHT_SELECTORS_FIELD, EVENT_DATA_STORE_ARN_FIELD, INSIGHTS_DESTINATION_FIELD));
    private final String trailARN;
    private final List<InsightSelector> insightSelectors;
    private final String eventDataStoreArn;
    private final String insightsDestination;

    private PutInsightSelectorsResponse(BuilderImpl builder) {
        super(builder);
        this.trailARN = builder.trailARN;
        this.insightSelectors = builder.insightSelectors;
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.insightsDestination = builder.insightsDestination;
    }

    public final String trailARN() {
        return this.trailARN;
    }

    public final boolean hasInsightSelectors() {
        return this.insightSelectors != null && !(this.insightSelectors instanceof SdkAutoConstructList);
    }

    public final List<InsightSelector> insightSelectors() {
        return this.insightSelectors;
    }

    public final String eventDataStoreArn() {
        return this.eventDataStoreArn;
    }

    public final String insightsDestination() {
        return this.insightsDestination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trailARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInsightSelectors() ? this.insightSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightsDestination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutInsightSelectorsResponse)) {
            return false;
        }
        PutInsightSelectorsResponse other = (PutInsightSelectorsResponse)((Object)obj);
        return Objects.equals(this.trailARN(), other.trailARN()) && this.hasInsightSelectors() == other.hasInsightSelectors() && Objects.equals(this.insightSelectors(), other.insightSelectors()) && Objects.equals(this.eventDataStoreArn(), other.eventDataStoreArn()) && Objects.equals(this.insightsDestination(), other.insightsDestination());
    }

    public final String toString() {
        return ToString.builder((String)"PutInsightSelectorsResponse").add("TrailARN", (Object)this.trailARN()).add("InsightSelectors", this.hasInsightSelectors() ? this.insightSelectors() : null).add("EventDataStoreArn", (Object)this.eventDataStoreArn()).add("InsightsDestination", (Object)this.insightsDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrailARN": {
                return Optional.ofNullable(clazz.cast(this.trailARN()));
            }
            case "InsightSelectors": {
                return Optional.ofNullable(clazz.cast(this.insightSelectors()));
            }
            case "EventDataStoreArn": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreArn()));
            }
            case "InsightsDestination": {
                return Optional.ofNullable(clazz.cast(this.insightsDestination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutInsightSelectorsResponse, T> g) {
        return obj -> g.apply((PutInsightSelectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String trailARN;
        private List<InsightSelector> insightSelectors = DefaultSdkAutoConstructList.getInstance();
        private String eventDataStoreArn;
        private String insightsDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(PutInsightSelectorsResponse model) {
            super(model);
            this.trailARN(model.trailARN);
            this.insightSelectors(model.insightSelectors);
            this.eventDataStoreArn(model.eventDataStoreArn);
            this.insightsDestination(model.insightsDestination);
        }

        public final String getTrailARN() {
            return this.trailARN;
        }

        public final void setTrailARN(String trailARN) {
            this.trailARN = trailARN;
        }

        @Override
        public final Builder trailARN(String trailARN) {
            this.trailARN = trailARN;
            return this;
        }

        public final List<InsightSelector.Builder> getInsightSelectors() {
            List<InsightSelector.Builder> result = InsightSelectorsCopier.copyToBuilder(this.insightSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInsightSelectors(Collection<InsightSelector.BuilderImpl> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copyFromBuilder(insightSelectors);
        }

        @Override
        public final Builder insightSelectors(Collection<InsightSelector> insightSelectors) {
            this.insightSelectors = InsightSelectorsCopier.copy(insightSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(InsightSelector ... insightSelectors) {
            this.insightSelectors(Arrays.asList(insightSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder insightSelectors(Consumer<InsightSelector.Builder> ... insightSelectors) {
            this.insightSelectors(Stream.of(insightSelectors).map(c -> (InsightSelector)((InsightSelector.Builder)InsightSelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEventDataStoreArn() {
            return this.eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getInsightsDestination() {
            return this.insightsDestination;
        }

        public final void setInsightsDestination(String insightsDestination) {
            this.insightsDestination = insightsDestination;
        }

        @Override
        public final Builder insightsDestination(String insightsDestination) {
            this.insightsDestination = insightsDestination;
            return this;
        }

        @Override
        public PutInsightSelectorsResponse build() {
            return new PutInsightSelectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutInsightSelectorsResponse> {
        public Builder trailARN(String var1);

        public Builder insightSelectors(Collection<InsightSelector> var1);

        public Builder insightSelectors(InsightSelector ... var1);

        public Builder insightSelectors(Consumer<InsightSelector.Builder> ... var1);

        public Builder eventDataStoreArn(String var1);

        public Builder insightsDestination(String var1);
    }
}

