/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.InsightType;
import software.amazon.awssdk.services.cloudtrail.model.InsightsMetricValuesCopier;
import software.amazon.awssdk.services.cloudtrail.model.TimestampsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInsightsMetricDataResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, ListInsightsMetricDataResponse> {
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSource").getter(ListInsightsMetricDataResponse.getter(ListInsightsMetricDataResponse::eventSource)).setter(ListInsightsMetricDataResponse.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventName").getter(ListInsightsMetricDataResponse.getter(ListInsightsMetricDataResponse::eventName)).setter(ListInsightsMetricDataResponse.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventName").build()}).build();
    private static final SdkField<String> INSIGHT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightType").getter(ListInsightsMetricDataResponse.getter(ListInsightsMetricDataResponse::insightTypeAsString)).setter(ListInsightsMetricDataResponse.setter(Builder::insightType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightType").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(ListInsightsMetricDataResponse.getter(ListInsightsMetricDataResponse::errorCode)).setter(ListInsightsMetricDataResponse.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Timestamps").getter(ListInsightsMetricDataResponse.getter(ListInsightsMetricDataResponse::timestamps)).setter(ListInsightsMetricDataResponse.setter(Builder::timestamps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Values").getter(ListInsightsMetricDataResponse.getter(ListInsightsMetricDataResponse::values)).setter(ListInsightsMetricDataResponse.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInsightsMetricDataResponse.getter(ListInsightsMetricDataResponse::nextToken)).setter(ListInsightsMetricDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_FIELD, EVENT_NAME_FIELD, INSIGHT_TYPE_FIELD, ERROR_CODE_FIELD, TIMESTAMPS_FIELD, VALUES_FIELD, NEXT_TOKEN_FIELD));
    private final String eventSource;
    private final String eventName;
    private final String insightType;
    private final String errorCode;
    private final List<Instant> timestamps;
    private final List<Double> values;
    private final String nextToken;

    private ListInsightsMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.eventSource = builder.eventSource;
        this.eventName = builder.eventName;
        this.insightType = builder.insightType;
        this.errorCode = builder.errorCode;
        this.timestamps = builder.timestamps;
        this.values = builder.values;
        this.nextToken = builder.nextToken;
    }

    public final String eventSource() {
        return this.eventSource;
    }

    public final String eventName() {
        return this.eventName;
    }

    public final InsightType insightType() {
        return InsightType.fromValue(this.insightType);
    }

    public final String insightTypeAsString() {
        return this.insightType;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final boolean hasTimestamps() {
        return this.timestamps != null && !(this.timestamps instanceof SdkAutoConstructList);
    }

    public final List<Instant> timestamps() {
        return this.timestamps;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<Double> values() {
        return this.values;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTimestamps() ? this.timestamps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsMetricDataResponse)) {
            return false;
        }
        ListInsightsMetricDataResponse other = (ListInsightsMetricDataResponse)((Object)obj);
        return Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.eventName(), other.eventName()) && Objects.equals(this.insightTypeAsString(), other.insightTypeAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && this.hasTimestamps() == other.hasTimestamps() && Objects.equals(this.timestamps(), other.timestamps()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInsightsMetricDataResponse").add("EventSource", (Object)this.eventSource()).add("EventName", (Object)this.eventName()).add("InsightType", (Object)this.insightTypeAsString()).add("ErrorCode", (Object)this.errorCode()).add("Timestamps", this.hasTimestamps() ? this.timestamps() : null).add("Values", this.hasValues() ? this.values() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "EventName": {
                return Optional.ofNullable(clazz.cast(this.eventName()));
            }
            case "InsightType": {
                return Optional.ofNullable(clazz.cast(this.insightTypeAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "Timestamps": {
                return Optional.ofNullable(clazz.cast(this.timestamps()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsMetricDataResponse, T> g) {
        return obj -> g.apply((ListInsightsMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String eventSource;
        private String eventName;
        private String insightType;
        private String errorCode;
        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();
        private List<Double> values = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsMetricDataResponse model) {
            super(model);
            this.eventSource(model.eventSource);
            this.eventName(model.eventName);
            this.insightType(model.insightType);
            this.errorCode(model.errorCode);
            this.timestamps(model.timestamps);
            this.values(model.values);
            this.nextToken(model.nextToken);
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final String getInsightType() {
            return this.insightType;
        }

        public final void setInsightType(String insightType) {
            this.insightType = insightType;
        }

        @Override
        public final Builder insightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        @Override
        public final Builder insightType(InsightType insightType) {
            this.insightType(insightType == null ? null : insightType.toString());
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Collection<Instant> getTimestamps() {
            if (this.timestamps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.timestamps;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
        }

        @Override
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Instant ... timestamps) {
            this.timestamps(Arrays.asList(timestamps));
            return this;
        }

        public final Collection<Double> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<Double> values) {
            this.values = InsightsMetricValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = InsightsMetricValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInsightsMetricDataResponse build() {
            return new ListInsightsMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInsightsMetricDataResponse> {
        public Builder eventSource(String var1);

        public Builder eventName(String var1);

        public Builder insightType(String var1);

        public Builder insightType(InsightType var1);

        public Builder errorCode(String var1);

        public Builder timestamps(Collection<Instant> var1);

        public Builder timestamps(Instant ... var1);

        public Builder values(Collection<Double> var1);

        public Builder values(Double ... var1);

        public Builder nextToken(String var1);
    }
}

