/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.LookupAttributeKey;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LookupAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LookupAttribute> {
    private static final SdkField<String> ATTRIBUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeKey").getter(LookupAttribute.getter(LookupAttribute::attributeKeyAsString)).setter(LookupAttribute.setter(Builder::attributeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeKey").build()}).build();
    private static final SdkField<String> ATTRIBUTE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeValue").getter(LookupAttribute.getter(LookupAttribute::attributeValue)).setter(LookupAttribute.setter(Builder::attributeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_KEY_FIELD, ATTRIBUTE_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LookupAttribute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeKey;
    private final String attributeValue;

    private LookupAttribute(BuilderImpl builder) {
        this.attributeKey = builder.attributeKey;
        this.attributeValue = builder.attributeValue;
    }

    public final LookupAttributeKey attributeKey() {
        return LookupAttributeKey.fromValue(this.attributeKey);
    }

    public final String attributeKeyAsString() {
        return this.attributeKey;
    }

    public final String attributeValue() {
        return this.attributeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeKeyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookupAttribute)) {
            return false;
        }
        LookupAttribute other = (LookupAttribute)obj;
        return Objects.equals(this.attributeKeyAsString(), other.attributeKeyAsString()) && Objects.equals(this.attributeValue(), other.attributeValue());
    }

    public final String toString() {
        return ToString.builder((String)"LookupAttribute").add("AttributeKey", (Object)this.attributeKeyAsString()).add("AttributeValue", (Object)this.attributeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeKey": {
                return Optional.ofNullable(clazz.cast(this.attributeKeyAsString()));
            }
            case "AttributeValue": {
                return Optional.ofNullable(clazz.cast(this.attributeValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AttributeKey", ATTRIBUTE_KEY_FIELD);
        map.put("AttributeValue", ATTRIBUTE_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LookupAttribute, T> g) {
        return obj -> g.apply((LookupAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeKey;
        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(LookupAttribute model) {
            this.attributeKey(model.attributeKey);
            this.attributeValue(model.attributeValue);
        }

        public final String getAttributeKey() {
            return this.attributeKey;
        }

        public final void setAttributeKey(String attributeKey) {
            this.attributeKey = attributeKey;
        }

        @Override
        public final Builder attributeKey(String attributeKey) {
            this.attributeKey = attributeKey;
            return this;
        }

        @Override
        public final Builder attributeKey(LookupAttributeKey attributeKey) {
            this.attributeKey(attributeKey == null ? null : attributeKey.toString());
            return this;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public LookupAttribute build() {
            return new LookupAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LookupAttribute> {
        public Builder attributeKey(String var1);

        public Builder attributeKey(LookupAttributeKey var1);

        public Builder attributeValue(String var1);
    }
}

