/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.PublicKey;

public class ListPublicKeysIterable
implements SdkIterable<ListPublicKeysResponse> {
    private final CloudTrailClient client;
    private final ListPublicKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPublicKeysIterable(CloudTrailClient client, ListPublicKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPublicKeysResponseFetcher();
    }

    public Iterator<ListPublicKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PublicKey> publicKeyList() {
        Function<ListPublicKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.publicKeyList() != null) {
                return response.publicKeyList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPublicKeysResponseFetcher
    implements SyncPageFetcher<ListPublicKeysResponse> {
        private ListPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListPublicKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPublicKeysResponse nextPage(ListPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListPublicKeysIterable.this.client.listPublicKeys(ListPublicKeysIterable.this.firstRequest);
            }
            return ListPublicKeysIterable.this.client.listPublicKeys((ListPublicKeysRequest)((Object)ListPublicKeysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

