/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.QueryResultRowsCopier;
import software.amazon.awssdk.services.cloudtrail.model.QueryStatistics;
import software.amazon.awssdk.services.cloudtrail.model.QueryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryResultsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, GetQueryResultsResponse> {
    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryStatus").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::queryStatusAsString)).setter(GetQueryResultsResponse.setter(Builder::queryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()}).build();
    private static final SdkField<QueryStatistics> QUERY_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueryStatistics").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::queryStatistics)).setter(GetQueryResultsResponse.setter(Builder::queryStatistics)).constructor(QueryStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatistics").build()}).build();
    private static final SdkField<List<List<Map<String, String>>>> QUERY_RESULT_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryResultRows").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::queryResultRows)).setter(GetQueryResultsResponse.setter(Builder::queryResultRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultRows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::nextToken)).setter(GetQueryResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(GetQueryResultsResponse.getter(GetQueryResultsResponse::errorMessage)).setter(GetQueryResultsResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STATUS_FIELD, QUERY_STATISTICS_FIELD, QUERY_RESULT_ROWS_FIELD, NEXT_TOKEN_FIELD, ERROR_MESSAGE_FIELD));
    private final String queryStatus;
    private final QueryStatistics queryStatistics;
    private final List<List<Map<String, String>>> queryResultRows;
    private final String nextToken;
    private final String errorMessage;

    private GetQueryResultsResponse(BuilderImpl builder) {
        super(builder);
        this.queryStatus = builder.queryStatus;
        this.queryStatistics = builder.queryStatistics;
        this.queryResultRows = builder.queryResultRows;
        this.nextToken = builder.nextToken;
        this.errorMessage = builder.errorMessage;
    }

    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(this.queryStatus);
    }

    public final String queryStatusAsString() {
        return this.queryStatus;
    }

    public final QueryStatistics queryStatistics() {
        return this.queryStatistics;
    }

    public final boolean hasQueryResultRows() {
        return this.queryResultRows != null && !(this.queryResultRows instanceof SdkAutoConstructList);
    }

    public final List<List<Map<String, String>>> queryResultRows() {
        return this.queryResultRows;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryResultRows() ? this.queryResultRows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryResultsResponse)) {
            return false;
        }
        GetQueryResultsResponse other = (GetQueryResultsResponse)((Object)obj);
        return Objects.equals(this.queryStatusAsString(), other.queryStatusAsString()) && Objects.equals(this.queryStatistics(), other.queryStatistics()) && this.hasQueryResultRows() == other.hasQueryResultRows() && Objects.equals(this.queryResultRows(), other.queryResultRows()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.errorMessage(), other.errorMessage());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryResultsResponse").add("QueryStatus", (Object)this.queryStatusAsString()).add("QueryStatistics", (Object)this.queryStatistics()).add("QueryResultRows", this.hasQueryResultRows() ? this.queryResultRows() : null).add("NextToken", (Object)this.nextToken()).add("ErrorMessage", (Object)this.errorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryStatus": {
                return Optional.ofNullable(clazz.cast(this.queryStatusAsString()));
            }
            case "QueryStatistics": {
                return Optional.ofNullable(clazz.cast(this.queryStatistics()));
            }
            case "QueryResultRows": {
                return Optional.ofNullable(clazz.cast(this.queryResultRows()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryResultsResponse, T> g) {
        return obj -> g.apply((GetQueryResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String queryStatus;
        private QueryStatistics queryStatistics;
        private List<List<Map<String, String>>> queryResultRows = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryResultsResponse model) {
            super(model);
            this.queryStatus(model.queryStatus);
            this.queryStatistics(model.queryStatistics);
            this.queryResultRows(model.queryResultRows);
            this.nextToken(model.nextToken);
            this.errorMessage(model.errorMessage);
        }

        public final String getQueryStatus() {
            return this.queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        public final QueryStatistics.Builder getQueryStatistics() {
            return this.queryStatistics != null ? this.queryStatistics.toBuilder() : null;
        }

        public final void setQueryStatistics(QueryStatistics.BuilderImpl queryStatistics) {
            this.queryStatistics = queryStatistics != null ? queryStatistics.build() : null;
        }

        @Override
        public final Builder queryStatistics(QueryStatistics queryStatistics) {
            this.queryStatistics = queryStatistics;
            return this;
        }

        public final Collection<? extends Collection<? extends Map<String, String>>> getQueryResultRows() {
            if (this.queryResultRows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryResultRows;
        }

        public final void setQueryResultRows(Collection<? extends Collection<? extends Map<String, String>>> queryResultRows) {
            this.queryResultRows = QueryResultRowsCopier.copy(queryResultRows);
        }

        @Override
        public final Builder queryResultRows(Collection<? extends Collection<? extends Map<String, String>>> queryResultRows) {
            this.queryResultRows = QueryResultRowsCopier.copy(queryResultRows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryResultRows(Collection<? extends Map<String, String>> ... queryResultRows) {
            this.queryResultRows((Collection<? extends Collection<? extends Map<String, String>>>)Arrays.asList(queryResultRows));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public GetQueryResultsResponse build() {
            return new GetQueryResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryResultsResponse> {
        public Builder queryStatus(String var1);

        public Builder queryStatus(QueryStatus var1);

        public Builder queryStatistics(QueryStatistics var1);

        default public Builder queryStatistics(Consumer<QueryStatistics.Builder> queryStatistics) {
            return this.queryStatistics((QueryStatistics)((QueryStatistics.Builder)QueryStatistics.builder().applyMutation(queryStatistics)).build());
        }

        public Builder queryResultRows(Collection<? extends Collection<? extends Map<String, String>>> var1);

        public Builder queryResultRows(Collection<? extends Map<String, String>> ... var1);

        public Builder nextToken(String var1);

        public Builder errorMessage(String var1);
    }
}

