/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;

public class ListChannelsPublisher
implements SdkPublisher<ListChannelsResponse> {
    private final CloudTrailAsyncClient client;
    private final ListChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelsPublisher(CloudTrailAsyncClient client, ListChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelsPublisher(CloudTrailAsyncClient client, ListChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListChannelsResponseFetcher
    implements AsyncPageFetcher<ListChannelsResponse> {
        private ListChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelsResponse> nextPage(ListChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelsPublisher.this.client.listChannels(ListChannelsPublisher.this.firstRequest);
            }
            return ListChannelsPublisher.this.client.listChannels((ListChannelsRequest)((Object)ListChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

